/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.magnetictrack.bankcard;

import org.apache.commons.lang3.StringUtils;
import us.fatehi.magnetictrack.BaseTrackData;
import us.fatehi.magnetictrack.bankcard.CardBrand;
import us.fatehi.magnetictrack.bankcard.MajorIndustryIdentifier;

public class PrimaryAccountNumber
extends BaseTrackData {
    private static final long serialVersionUID = -7012531091389412459L;
    private final String accountNumber;
    private final CardBrand cardBrand;
    private final MajorIndustryIdentifier majorIndustryIdentifier;
    private final boolean passesLuhnCheck;

    public PrimaryAccountNumber() {
        this(null);
    }

    public PrimaryAccountNumber(String rawAccountNumber) {
        super(rawAccountNumber);
        this.accountNumber = non_digit.matcher(StringUtils.trimToEmpty((String)rawAccountNumber)).replaceAll("");
        this.passesLuhnCheck = this.passesLuhnCheck();
        this.majorIndustryIdentifier = MajorIndustryIdentifier.from(this.accountNumber);
        this.cardBrand = CardBrand.from(this.accountNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrimaryAccountNumber)) {
            return false;
        }
        PrimaryAccountNumber other = (PrimaryAccountNumber)obj;
        return !(this.accountNumber == null ? other.accountNumber != null : !this.accountNumber.equals(other.accountNumber));
    }

    @Override
    public boolean exceedsMaximumLength() {
        return StringUtils.trimToEmpty((String)this.getRawTrackData()).length() > 19;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public CardBrand getCardBrand() {
        return this.cardBrand;
    }

    public String getIssuerIdentificationNumber() {
        return StringUtils.left((String)this.accountNumber, (int)6);
    }

    public MajorIndustryIdentifier getMajorIndustryIdentifier() {
        return this.majorIndustryIdentifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountNumber == null ? 0 : this.accountNumber.hashCode());
        return result;
    }

    public boolean hasPrimaryAccountNumber() {
        return !StringUtils.isBlank((CharSequence)this.accountNumber);
    }

    public boolean isPassesLuhnCheck() {
        return this.passesLuhnCheck;
    }

    @Override
    public String toString() {
        return this.accountNumber;
    }

    private boolean passesLuhnCheck() {
        int length = this.accountNumber.length();
        int sum = 0;
        boolean alternate = false;
        for (int i = length - 1; i >= 0; --i) {
            int digit = Character.digit(this.accountNumber.charAt(i), 10);
            if (alternate) {
                digit = (digit *= 2) > 9 ? digit - 9 : digit;
            }
            sum += digit;
            alternate = !alternate;
        }
        boolean passesLuhnCheck = sum % 10 == 0;
        return passesLuhnCheck;
    }
}

