/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.magnetictrack.bankcard;

import us.fatehi.magnetictrack.bankcard.ServiceCodeType;

public enum ServiceCode3 implements ServiceCodeType
{
    unknown(-1, "Unknown", ""),
    v_0(0, "No restrictions", "PIN required"),
    v_1(1, "No restrictions", "None"),
    v_2(2, "Goods and services only", "None"),
    v_3(3, "ATM only", "PIN required"),
    v_4(4, "Cash only", "None"),
    v_5(5, "Goods and services only", "PIN required"),
    v_6(6, "No restrictions", "Prompt for PIN if PED present"),
    v_7(7, "Goods and services only", "Prompt for PIN if PED present");

    private final int value;
    private final String allowedServices;
    private final String pinRequirements;

    private ServiceCode3(int value, String allowedServices, String pinRequirements) {
        this.value = value;
        this.allowedServices = allowedServices;
        this.pinRequirements = pinRequirements;
    }

    public String getAllowedServices() {
        return this.allowedServices;
    }

    @Override
    public String getDescription() {
        return String.format("Allowed Services: %s. PIN Requirements: %s.", this.allowedServices, this.pinRequirements);
    }

    public String getPinRequirements() {
        return this.pinRequirements;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("%d - %s", this.value, this.getDescription());
    }
}

