/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.magnetictrack.bankcard;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import us.fatehi.magnetictrack.bankcard.BaseBankCardTrackData;
import us.fatehi.magnetictrack.bankcard.ExpirationDate;
import us.fatehi.magnetictrack.bankcard.Name;
import us.fatehi.magnetictrack.bankcard.PrimaryAccountNumber;
import us.fatehi.magnetictrack.bankcard.ServiceCode;

public class Track1FormatB
extends BaseBankCardTrackData {
    private static final long serialVersionUID = 3020739300944280022L;
    private static final Pattern track1FormatBPattern = Pattern.compile("(%([A-Z])([0-9]{1,19})\\^([^\\^]{2,26})\\^([0-9]{4}|\\^)([0-9]{3}|\\^)?([^\\?]+)?\\?)[\\t\\n\\r ]?.*");
    private final String formatCode;
    private final PrimaryAccountNumber pan;
    private final Name name;
    private final ExpirationDate expirationDate;
    private final ServiceCode serviceCode;

    public static Track1FormatB from(String rawTrackData) {
        String discretionaryData;
        String rawTrack1Data;
        Matcher matcher = track1FormatBPattern.matcher(StringUtils.trimToEmpty((String)rawTrackData));
        if (matcher.matches()) {
            rawTrack1Data = Track1FormatB.getGroup(matcher, 1);
            discretionaryData = Track1FormatB.getGroup(matcher, 7);
        } else {
            rawTrack1Data = "";
            discretionaryData = "";
        }
        return new Track1FormatB(rawTrack1Data, discretionaryData, matcher);
    }

    private Track1FormatB(String rawTrack1Data, String discretionaryData, Matcher matcher) {
        super(rawTrack1Data, discretionaryData);
        if (matcher.matches()) {
            this.formatCode = Track1FormatB.getGroup(matcher, 2);
            this.pan = new PrimaryAccountNumber(Track1FormatB.getGroup(matcher, 3));
            this.name = new Name(Track1FormatB.getGroup(matcher, 4));
            this.expirationDate = new ExpirationDate(Track1FormatB.getGroup(matcher, 5));
            this.serviceCode = new ServiceCode(Track1FormatB.getGroup(matcher, 6));
        } else {
            this.formatCode = "";
            this.pan = new PrimaryAccountNumber();
            this.name = new Name();
            this.expirationDate = new ExpirationDate();
            this.serviceCode = new ServiceCode();
        }
    }

    @Override
    public boolean exceedsMaximumLength() {
        return this.hasRawTrackData() && this.getRawTrackData().length() > 79;
    }

    public ExpirationDate getExpirationDate() {
        return this.expirationDate;
    }

    public String getFormatCode() {
        return this.formatCode;
    }

    public Name getName() {
        return this.name;
    }

    public PrimaryAccountNumber getPrimaryAccountNumber() {
        return this.pan;
    }

    public ServiceCode getServiceCode() {
        return this.serviceCode;
    }

    public boolean hasExpirationDate() {
        return this.expirationDate != null && this.expirationDate.hasExpirationDate();
    }

    public boolean hasFormatCode() {
        return !StringUtils.isBlank((CharSequence)this.formatCode);
    }

    public boolean hasName() {
        return this.name != null && this.name.hasName();
    }

    public boolean hasPrimaryAccountNumber() {
        return this.pan != null;
    }

    public boolean hasServiceCode() {
        return this.serviceCode != null && this.serviceCode.hasServiceCode();
    }
}

