/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.magnetictrack.bankcard;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import us.fatehi.magnetictrack.bankcard.BaseBankCardTrackData;
import us.fatehi.magnetictrack.bankcard.ExpirationDate;
import us.fatehi.magnetictrack.bankcard.PrimaryAccountNumber;
import us.fatehi.magnetictrack.bankcard.ServiceCode;

public class Track2
extends BaseBankCardTrackData {
    private static final long serialVersionUID = 2209024303926876386L;
    private static final Pattern track2Pattern = Pattern.compile(".*[\\t\\n\\r ]?(;([0-9]{1,19})=([0-9]{4})([0-9]{3})(.*)\\?).*");
    private final PrimaryAccountNumber pan;
    private final ExpirationDate expirationDate;
    private final ServiceCode serviceCode;

    public static Track2 from(String rawTrackData) {
        String discretionaryData;
        String rawTrack2Data;
        Matcher matcher = track2Pattern.matcher(StringUtils.trimToEmpty((String)rawTrackData));
        if (matcher.matches()) {
            rawTrack2Data = Track2.getGroup(matcher, 1);
            discretionaryData = Track2.getGroup(matcher, 5);
        } else {
            rawTrack2Data = "";
            discretionaryData = "";
        }
        return new Track2(rawTrack2Data, discretionaryData, matcher);
    }

    private Track2(String rawTrack2Data, String discretionaryData, Matcher matcher) {
        super(rawTrack2Data, discretionaryData);
        if (matcher.matches()) {
            this.pan = new PrimaryAccountNumber(Track2.getGroup(matcher, 2));
            this.expirationDate = new ExpirationDate(Track2.getGroup(matcher, 3));
            this.serviceCode = new ServiceCode(Track2.getGroup(matcher, 4));
        } else {
            this.pan = null;
            this.expirationDate = null;
            this.serviceCode = null;
        }
    }

    @Override
    public boolean exceedsMaximumLength() {
        return this.hasRawTrackData() && this.getRawTrackData().length() > 40;
    }

    public ExpirationDate getExpirationDate() {
        return this.expirationDate;
    }

    public PrimaryAccountNumber getPrimaryAccountNumber() {
        return this.pan;
    }

    public ServiceCode getServiceCode() {
        return this.serviceCode;
    }

    public boolean hasExpirationDate() {
        return this.expirationDate != null && this.expirationDate.hasExpirationDate();
    }

    public boolean hasPrimaryAccountNumber() {
        return this.pan != null && this.pan.hasPrimaryAccountNumber();
    }

    public boolean hasServiceCode() {
        return this.serviceCode != null && this.serviceCode.hasServiceCode();
    }
}

