/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.magnetictrack.bankcard;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import us.fatehi.magnetictrack.bankcard.BaseBankCardTrackData;

public class Track3
extends BaseBankCardTrackData {
    private static final long serialVersionUID = 1469806733607842924L;
    private static final Pattern track3Pattern = Pattern.compile(".*[\\t\\n\\r ]?(\\+(.*)\\?)");

    public static Track3 from(String rawTrackData) {
        String discretionaryData;
        String rawTrack2Data;
        Matcher matcher = track3Pattern.matcher(StringUtils.trimToEmpty((String)rawTrackData));
        if (matcher.matches()) {
            rawTrack2Data = Track3.getGroup(matcher, 1);
            discretionaryData = Track3.getGroup(matcher, 2);
        } else {
            rawTrack2Data = "";
            discretionaryData = "";
        }
        return new Track3(rawTrack2Data, discretionaryData);
    }

    private Track3(String rawTrack2Data, String discretionaryData) {
        super(rawTrack2Data, discretionaryData);
    }

    @Override
    public boolean exceedsMaximumLength() {
        return false;
    }
}

