/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Objects;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.SchemaCrawlerInfo;

final class ImmutableCrawlInfo
implements CrawlInfo {
    private static final long serialVersionUID = 5982990326485881993L;
    private final String schemaCrawlerInfo;
    private final String jdbcDriverInfo;
    private final String databaseInfo;
    private final String title;
    private final LocalDateTime crawlTimestamp;

    ImmutableCrawlInfo(SchemaCrawlerInfo schemaCrawlerInfo, JdbcDriverInfo jdbcDriverInfo, DatabaseInfo databaseInfo, String title) {
        Objects.requireNonNull(schemaCrawlerInfo);
        this.schemaCrawlerInfo = String.format("%s %s", schemaCrawlerInfo.getSchemaCrawlerProductName(), schemaCrawlerInfo.getSchemaCrawlerVersion());
        Objects.requireNonNull(jdbcDriverInfo);
        this.jdbcDriverInfo = String.format("%s %s", jdbcDriverInfo.getDriverName(), jdbcDriverInfo.getDriverVersion());
        Objects.requireNonNull(databaseInfo);
        this.databaseInfo = String.format("%s %s", databaseInfo.getProductName(), databaseInfo.getProductVersion());
        this.title = title;
        this.crawlTimestamp = LocalDateTime.now();
    }

    @Override
    public LocalDateTime getCrawlTimestamp() {
        return this.crawlTimestamp;
    }

    @Override
    public String getDatabaseInfo() {
        return this.databaseInfo;
    }

    @Override
    public String getJdbcDriverInfo() {
        return this.jdbcDriverInfo;
    }

    @Override
    public String getSchemaCrawlerInfo() {
        return this.schemaCrawlerInfo;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String toString() {
        StringBuilder info = new StringBuilder(1024);
        info.append("-- generated by: ").append(this.schemaCrawlerInfo).append(System.lineSeparator());
        info.append("-- generated on: ").append(DateTimeFormatter.ofPattern((String)"yyyy-MM-dd HH:mm:ss").format((TemporalAccessor)this.getCrawlTimestamp())).append(System.lineSeparator());
        info.append("-- database: ").append(this.databaseInfo).append(System.lineSeparator());
        info.append("-- driver: ").append(this.jdbcDriverInfo).append(System.lineSeparator());
        return info.toString();
    }
}

