/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.DatabaseSpecificOverrideOptions;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.utility.Identifiers;
import schemacrawler.utility.JavaSqlTypes;
import schemacrawler.utility.TableTypes;
import schemacrawler.utility.TypeMap;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

final class RetrieverConnection {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(RetrieverConnection.class.getName());
    private final Connection connection;
    private final DatabaseMetaData metaData;
    private final boolean supportsCatalogs;
    private final boolean supportsSchemas;
    private final MetadataRetrievalStrategy tableRetrievalStrategy;
    private final MetadataRetrievalStrategy tableColumnRetrievalStrategy;
    private final MetadataRetrievalStrategy pkRetrievalStrategy;
    private final MetadataRetrievalStrategy indexRetrievalStrategy;
    private final MetadataRetrievalStrategy fkRetrievalStrategy;
    private final Identifiers identifiers;
    private final InformationSchemaViews informationSchemaViews;
    private final TableTypes tableTypes;
    private final JavaSqlTypes javaSqlTypes;
    private final TypeMap typeMap;

    private static String lookupIdentifierQuoteString(DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions, DatabaseMetaData metaData) throws SQLException {
        String identifierQuoteString = databaseSpecificOverrideOptions != null && databaseSpecificOverrideOptions.hasOverrideForIdentifierQuoteString() ? databaseSpecificOverrideOptions.getIdentifierQuoteString() : metaData.getIdentifierQuoteString();
        if (Utility.isBlank(identifierQuoteString)) {
            identifierQuoteString = "";
        }
        return identifierQuoteString;
    }

    private static boolean lookupSupportsCatalogs(DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions, DatabaseMetaData metaData) throws SQLException {
        boolean supportsCatalogs = databaseSpecificOverrideOptions != null && databaseSpecificOverrideOptions.hasOverrideForSupportsCatalogs() ? databaseSpecificOverrideOptions.isSupportsCatalogs() : metaData.supportsCatalogsInTableDefinitions();
        return supportsCatalogs;
    }

    private static boolean lookupSupportsSchemas(DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions, DatabaseMetaData metaData) throws SQLException {
        boolean supportsSchemas = databaseSpecificOverrideOptions != null && databaseSpecificOverrideOptions.hasOverrideForSupportsSchemas() ? databaseSpecificOverrideOptions.isSupportsSchemas() : metaData.supportsSchemasInTableDefinitions();
        return supportsSchemas;
    }

    RetrieverConnection(Connection connection, DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions) throws SQLException {
        try {
            DatabaseUtility.checkConnection(connection);
        }
        catch (SchemaCrawlerException e) {
            throw new SQLException("Bad database connection", e);
        }
        this.connection = connection;
        this.metaData = connection.getMetaData();
        Objects.requireNonNull(databaseSpecificOverrideOptions, "No database specific overrides provided");
        this.informationSchemaViews = databaseSpecificOverrideOptions.getInformationSchemaViews();
        this.supportsCatalogs = RetrieverConnection.lookupSupportsCatalogs(databaseSpecificOverrideOptions, this.metaData);
        LOGGER.log(Level.CONFIG, new StringFormat("Database %s catalogs", this.supportsCatalogs ? "supports" : "does not support"));
        this.supportsSchemas = RetrieverConnection.lookupSupportsSchemas(databaseSpecificOverrideOptions, this.metaData);
        LOGGER.log(Level.CONFIG, new StringFormat("Database %s schemas", this.supportsSchemas ? "supports" : "does not support"));
        this.tableRetrievalStrategy = databaseSpecificOverrideOptions.getTableRetrievalStrategy();
        this.tableColumnRetrievalStrategy = databaseSpecificOverrideOptions.getTableColumnRetrievalStrategy();
        this.pkRetrievalStrategy = databaseSpecificOverrideOptions.getPrimaryKeyRetrievalStrategy();
        this.indexRetrievalStrategy = databaseSpecificOverrideOptions.getIndexRetrievalStrategy();
        this.fkRetrievalStrategy = databaseSpecificOverrideOptions.getForeignKeyRetrievalStrategy();
        String identifierQuoteString = RetrieverConnection.lookupIdentifierQuoteString(databaseSpecificOverrideOptions, this.metaData);
        LOGGER.log(Level.CONFIG, new StringFormat("Database identifier quote string is <%s>", identifierQuoteString));
        this.identifiers = Identifiers.identifiers().withConnection(connection).withIdentifierQuoteString(identifierQuoteString).build();
        this.tableTypes = new TableTypes(connection);
        LOGGER.log(Level.CONFIG, new StringFormat("Supported table types are <%s>", this.tableTypes));
        this.typeMap = new TypeMap(connection);
        this.javaSqlTypes = new JavaSqlTypes();
    }

    public MetadataRetrievalStrategy getForeignKeyRetrievalStrategy() {
        return this.fkRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getIndexRetrievalStrategy() {
        return this.indexRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getPrimaryKeyRetrievalStrategy() {
        return this.pkRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getTableRetrievalStrategy() {
        return this.tableRetrievalStrategy;
    }

    Connection getConnection() {
        return this.connection;
    }

    Identifiers getIdentifiers() {
        return this.identifiers;
    }

    InformationSchemaViews getInformationSchemaViews() {
        return this.informationSchemaViews;
    }

    JavaSqlTypes getJavaSqlTypes() {
        return this.javaSqlTypes;
    }

    DatabaseMetaData getMetaData() {
        return this.metaData;
    }

    MetadataRetrievalStrategy getTableColumnRetrievalStrategy() {
        return this.tableColumnRetrievalStrategy;
    }

    TableTypes getTableTypes() {
        return this.tableTypes;
    }

    TypeMap getTypeMap() {
        return this.typeMap;
    }

    boolean isSupportsCatalogs() {
        return this.supportsCatalogs;
    }

    boolean isSupportsSchemas() {
        return this.supportsSchemas;
    }
}

