/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableSequence;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.utility.Query;
import sf.util.SchemaCrawlerLogger;

final class SequenceRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SequenceRetriever.class.getName());

    SequenceRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveSequenceInformation(InclusionRule sequenceInclusionRule) throws SQLException {
        InclusionRuleFilter<MutableSequence> sequenceFilter = new InclusionRuleFilter<MutableSequence>(sequenceInclusionRule, false);
        if (sequenceFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving sequences, since this was not requested");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving sequences");
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasSequencesSql()) {
            LOGGER.log(Level.FINE, "Sequence definition SQL statement was not provided");
            return;
        }
        NamedObjectList<SchemaReference> schemas = this.getAllSchemas();
        Query sequencesDefinitionSql = informationSchemaViews.getSequencesSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(sequencesDefinitionSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.nameQuotedName(results.getString("SEQUENCE_CATALOG"));
                String schemaName = this.nameQuotedName(results.getString("SEQUENCE_SCHEMA"));
                String sequenceName = this.nameQuotedName(results.getString("SEQUENCE_NAME"));
                BigInteger minimumValue = results.getBigInteger("MINIMUM_VALUE");
                BigInteger maximumValue = results.getBigInteger("MAXIMUM_VALUE");
                BigInteger increment = results.getBigInteger("INCREMENT");
                long longIncrement = increment == null ? 1L : increment.longValue();
                boolean cycle = results.getBoolean("CYCLE_OPTION");
                SchemaReference schema = new SchemaReference(catalogName, schemaName);
                if (!schemas.contains(schema)) continue;
                MutableSequence sequence = new MutableSequence(schema, sequenceName);
                sequence.setMaximumValue(maximumValue);
                sequence.setMinimumValue(minimumValue);
                sequence.setIncrement(longIncrement);
                sequence.setCycle(cycle);
                sequence.addAttributes(results.getAttributes());
                if (!sequenceFilter.test(sequence)) continue;
                this.catalog.addSequence(sequence);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve sequences", (Throwable)e);
        }
    }
}

