/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import com.annimon.stream.Optional;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.schema.Column;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.utility.Query;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

final class TableColumnRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TableColumnRetriever.class.getName());

    TableColumnRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveColumns(NamedObjectList<MutableTable> allTables, InclusionRule columnInclusionRule) throws SQLException {
        Objects.requireNonNull(allTables);
        InclusionRuleFilter<Column> columnFilter = new InclusionRuleFilter<Column>(columnInclusionRule, true);
        if (columnFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving columns, since this was not requested");
            return;
        }
        MetadataRetrievalStrategy tableColumnRetrievalStrategy = this.getRetrieverConnection().getTableColumnRetrievalStrategy();
        switch (tableColumnRetrievalStrategy) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving table columns, using fast data dictionary retrieval");
                this.retrieveColumnsFromDataDictionary(allTables, columnFilter);
                break;
            }
            case metadata_all: {
                LOGGER.log(Level.INFO, "Retrieving table columns, using fast meta-data retrieval");
                this.retrieveColumnsFromMetadataForAllTables(allTables, columnFilter);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving table columns");
                this.retrieveColumnsFromMetadata(allTables, columnFilter);
                break;
            }
        }
    }

    void retrieveHiddenColumns(NamedObjectList<MutableTable> allTables, InclusionRule columnInclusionRule) throws SQLException {
        Objects.requireNonNull(allTables);
        InclusionRuleFilter<Column> columnFilter = new InclusionRuleFilter<Column>(columnInclusionRule, true);
        if (columnFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving columns, since this was not requested");
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasExtHiddenTableColumnsSql()) {
            LOGGER.log(Level.INFO, "No hidden table columns SQL provided");
            return;
        }
        Query hiddenColumnsSql = informationSchemaViews.getExtHiddenTableColumnsSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(hiddenColumnsSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrieveHiddenColumns");
            while (results.next()) {
                MutableColumn column = this.createTableColumn(results, allTables, columnFilter, false);
                if (column == null) continue;
                column.setHidden(true);
            }
        }
    }

    private MutableColumn createTableColumn(MetadataResultSet results, NamedObjectList<MutableTable> allTables, InclusionRuleFilter<Column> columnFilter, boolean isHidden) throws SQLException {
        String defaultValue = results.getString("COLUMN_DEF");
        String columnCatalogName = this.nameQuotedName(results.getString("TABLE_CAT"));
        String schemaName = this.nameQuotedName(results.getString("TABLE_SCHEM"));
        String tableName = this.nameQuotedName(results.getString("TABLE_NAME"));
        String columnName = this.nameQuotedName(results.getString("COLUMN_NAME"));
        LOGGER.log(Level.FINE, new StringFormat("Retrieving column <%s.%s.%s.%s>", columnCatalogName, schemaName, tableName, columnName));
        Optional<MutableTable> optionalTable = allTables.lookup(new SchemaReference(columnCatalogName, schemaName), tableName);
        if (!optionalTable.isPresent()) {
            return null;
        }
        MutableTable table = (MutableTable)optionalTable.get();
        MutableColumn column = this.lookupOrCreateColumn(table, columnName);
        if (columnFilter.test(column) && this.belongsToSchema(table, columnCatalogName, schemaName)) {
            column = this.lookupOrCreateColumn(table, columnName);
            int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
            int dataType = results.getInt("DATA_TYPE", 0);
            String typeName = results.getString("TYPE_NAME");
            int size = results.getInt("COLUMN_SIZE", 0);
            int decimalDigits = results.getInt("DECIMAL_DIGITS", 0);
            boolean isNullable = results.getInt("NULLABLE", 2) == 1;
            boolean isAutoIncremented = results.getBoolean("IS_AUTOINCREMENT");
            boolean isGenerated = results.getBoolean("IS_GENERATEDCOLUMN");
            String remarks = results.getString("REMARKS");
            column.setOrdinalPosition(ordinalPosition);
            column.setColumnDataType(this.lookupOrCreateColumnDataType(table.getSchema(), dataType, typeName));
            column.setSize(size);
            column.setDecimalDigits(decimalDigits);
            column.setNullable(isNullable);
            column.setAutoIncremented(isAutoIncremented);
            column.setGenerated(isGenerated);
            column.setRemarks(remarks);
            if (defaultValue != null) {
                column.setDefaultValue(defaultValue);
            }
            column.addAttributes(results.getAttributes());
            LOGGER.log(Level.FINER, new StringFormat("Adding %scolumn to table <%s>", isHidden ? "hidden " : "", column.getFullName()));
            if (isHidden) {
                table.addHiddenColumn(column);
            } else {
                table.addColumn(column);
            }
        }
        return column;
    }

    private MutableColumn lookupOrCreateColumn(MutableTable table, String columnName) {
        Optional<MutableColumn> columnOptional = table.lookupColumn(columnName);
        MutableColumn column = columnOptional.isPresent() ? (MutableColumn)columnOptional.get() : new MutableColumn(table, columnName);
        return column;
    }

    private void retrieveColumnsFromDataDictionary(NamedObjectList<MutableTable> allTables, InclusionRuleFilter<Column> columnFilter) throws SchemaCrawlerSQLException, SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasTableColumnsSql()) {
            throw new SchemaCrawlerSQLException("No table columns SQL provided", null);
        }
        Query tableColumnsSql = informationSchemaViews.getTableColumnsSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableColumnsSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrieveColumnsFromDataDictionary");
            while (results.next()) {
                this.createTableColumn(results, allTables, columnFilter, false);
            }
        }
    }

    private void retrieveColumnsFromMetadata(NamedObjectList<MutableTable> allTables, InclusionRuleFilter<Column> columnFilter) throws SchemaCrawlerSQLException {
        for (MutableTable table : allTables) {
            LOGGER.log(Level.FINE, "Retrieving columns for " + table);
            try {
                MetadataResultSet results = new MetadataResultSet(this.getMetaData().getColumns(this.unquotedName(table.getSchema().getCatalogName()), this.unquotedName(table.getSchema().getName()), this.unquotedName(table.getName()), null));
                Throwable throwable = null;
                try {
                    while (results.next()) {
                        this.createTableColumn(results, allTables, columnFilter, false);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (results == null) continue;
                    if (throwable != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    results.close();
                }
            }
            catch (SQLException e) {
                throw new SchemaCrawlerSQLException(String.format("Could not retrieve columns for %s <%s>", table.getTableType(), table), e);
            }
        }
    }

    private void retrieveColumnsFromMetadataForAllTables(NamedObjectList<MutableTable> allTables, InclusionRuleFilter<Column> columnFilter) throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getColumns(null, null, "%", "%"));){
            while (results.next()) {
                this.createTableColumn(results, allTables, columnFilter, false);
            }
        }
    }
}

