/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import com.annimon.stream.function.Predicate;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schemacrawler.IncludeAll;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

public class DatabaseObjectFilter<D extends DatabaseObject>
implements Predicate<D> {
    private final InclusionRule schemaInclusionRule;
    private final InclusionRule databaseObjectInclusionRule;

    public DatabaseObjectFilter(SchemaCrawlerOptions options, InclusionRule databaseObjectInclusionRule) {
        this.schemaInclusionRule = options != null ? options.getSchemaInclusionRule() : new IncludeAll();
        this.databaseObjectInclusionRule = databaseObjectInclusionRule != null ? databaseObjectInclusionRule : new IncludeAll();
    }

    public boolean test(D databaseObject) {
        if (databaseObject == null) {
            return false;
        }
        boolean include = true;
        if (include && this.schemaInclusionRule != null) {
            include = this.schemaInclusionRule.test(databaseObject.getSchema().getFullName());
        }
        if (include && this.databaseObjectInclusionRule != null) {
            include = this.databaseObjectInclusionRule.test(databaseObject.getFullName());
        }
        return include;
    }
}

