/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import com.annimon.stream.function.Predicate;
import java.util.logging.Level;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.schema.Trigger;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

class TableGrepFilter
implements Predicate<Table> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TableGrepFilter.class.getName());
    private final boolean invertMatch;
    private final InclusionRule grepColumnInclusionRule;
    private final InclusionRule grepDefinitionInclusionRule;

    public TableGrepFilter(SchemaCrawlerOptions options) {
        this.invertMatch = options.isGrepInvertMatch();
        this.grepColumnInclusionRule = options.getGrepColumnInclusionRule();
        this.grepDefinitionInclusionRule = options.getGrepDefinitionInclusionRule();
    }

    public boolean test(Table table) {
        boolean include;
        boolean checkIncludeForDefinitions;
        boolean checkIncludeForColumns = this.grepColumnInclusionRule != null;
        boolean bl = checkIncludeForDefinitions = this.grepDefinitionInclusionRule != null;
        if (!checkIncludeForColumns && !checkIncludeForDefinitions) {
            return true;
        }
        boolean includeForColumns = false;
        boolean includeForDefinitions = false;
        for (Column column : table.getColumns()) {
            if (checkIncludeForColumns && this.grepColumnInclusionRule.test(column.getFullName())) {
                includeForColumns = true;
                break;
            }
            if (!checkIncludeForDefinitions || !this.grepDefinitionInclusionRule.test(column.getRemarks())) continue;
            includeForDefinitions = true;
            break;
        }
        if (checkIncludeForDefinitions) {
            if (this.grepDefinitionInclusionRule.test(table.getRemarks())) {
                includeForDefinitions = true;
            }
            if (this.grepDefinitionInclusionRule.test(table.getDefinition())) {
                includeForDefinitions = true;
            }
            for (Trigger trigger : table.getTriggers()) {
                if (!this.grepDefinitionInclusionRule.test(trigger.getActionStatement())) continue;
                includeForDefinitions = true;
                break;
            }
        }
        boolean bl2 = include = checkIncludeForColumns && includeForColumns || checkIncludeForDefinitions && includeForDefinitions;
        if (this.invertMatch) {
            boolean bl3 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, new StringFormat("Excluding table <%s>", table));
        }
        return include;
    }
}

