/*
 * Decompiled with CFR 0.152.
 */
package sf.util.graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import sf.util.graph.DirectedEdge;
import sf.util.graph.DirectedGraph;
import sf.util.graph.Vertex;

public class TarjanStronglyConnectedComponentFinder<T extends Comparable<? super T>> {
    private final DirectedGraph<T> graph;
    private final Collection<List<T>> stronglyConnectedComponents;
    private final Stack<Vertex<T>> stack;

    public TarjanStronglyConnectedComponentFinder(DirectedGraph<T> graph) {
        this.graph = Objects.requireNonNull(graph);
        this.stronglyConnectedComponents = new HashSet<List<T>>();
        this.stack = new Stack();
    }

    public Collection<List<T>> detectCycles() {
        for (Vertex<T> vertex : this.graph.vertexSet()) {
            if (vertex.hasAttribute("index")) continue;
            this.strongConnect(vertex, 0);
        }
        return this.stronglyConnectedComponents;
    }

    private void strongConnect(Vertex<T> vertexFrom, int index) {
        vertexFrom.putAttribute("index", index);
        vertexFrom.putAttribute("lowlink", index);
        this.stack.push(vertexFrom);
        for (DirectedEdge<T> edge : this.graph.getOutgoingEdges(vertexFrom)) {
            Vertex<T> vertexTo = edge.getTo();
            if (!vertexTo.hasAttribute("index")) {
                this.strongConnect(vertexTo, index + 1);
                vertexFrom.putAttribute("lowlink", Math.min((Integer)vertexFrom.getAttribute("lowlink"), (Integer)vertexTo.getAttribute("lowlink")));
                continue;
            }
            if (!this.stack.contains(vertexTo)) continue;
            vertexFrom.putAttribute("lowlink", Math.min((Integer)vertexFrom.getAttribute("lowlink"), (Integer)vertexTo.getAttribute("index")));
        }
        if (vertexFrom.getAttribute("lowlink") == vertexFrom.getAttribute("index")) {
            Vertex<T> sccVertex;
            LinkedList<T> scc = new LinkedList<T>();
            do {
                sccVertex = this.stack.pop();
                scc.addFirst(sccVertex.getValue());
            } while (!vertexFrom.equals(sccVertex));
            if (scc.size() > 1) {
                this.stronglyConnectedComponents.add(scc);
            }
        }
    }
}

