/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.schema.AttributedObject;
import schemacrawler.schema.DescribedObject;
import sf.util.Utility;

abstract class AbstractNamedObjectWithAttributes
extends AbstractNamedObject
implements AttributedObject,
DescribedObject {
    private static final long serialVersionUID = -1486322887991472729L;
    private String remarks;
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();

    AbstractNamedObjectWithAttributes(String name) {
        super(name);
    }

    @Override
    public final <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public final <T> T getAttribute(String name, T defaultValue) {
        Object attributeValue = this.attributeMap.get(name);
        if (attributeValue == null) {
            return defaultValue;
        }
        try {
            return (T)attributeValue;
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public final Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    @Override
    public final String getRemarks() {
        return this.remarks;
    }

    @Override
    public final boolean hasAttribute(String name) {
        return this.attributeMap.containsKey(name);
    }

    @Override
    public final boolean hasRemarks() {
        return this.remarks != null && !this.remarks.isEmpty();
    }

    @Override
    public final <T> Optional<T> lookupAttribute(String name) {
        return Optional.of(this.getAttribute(name));
    }

    @Override
    public final void removeAttribute(String name) {
        if (!Utility.isBlank(name)) {
            this.attributeMap.remove(name);
        }
    }

    public final void setAttribute(String name, Object value) {
        if (!Utility.isBlank(name)) {
            if (value == null) {
                this.attributeMap.remove(name);
            } else {
                this.attributeMap.put(name, value);
            }
        }
    }

    protected final void addAttributes(Map<String, Object> values) {
        if (values != null) {
            this.attributeMap.putAll(values);
        }
    }

    protected final void setRemarks(String remarks) {
        this.remarks = remarks == null ? "" : remarks;
    }
}

