/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.UUID;
import schemacrawler.BaseProductVersion;
import schemacrawler.JvmSystemInfo;
import schemacrawler.OperatingSystemInfo;
import schemacrawler.ProductVersion;
import schemacrawler.SchemaCrawlerInfo;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;

final class ImmutableCrawlInfo
implements CrawlInfo {
    private static final long serialVersionUID = 5982990326485881993L;
    private final ProductVersion schemaCrawlerInfo = new SchemaCrawlerInfo();
    private final ProductVersion jdbcDriverInfo;
    private final ProductVersion databaseInfo;
    private final ProductVersion osInfo = new OperatingSystemInfo();
    private final ProductVersion jvmInfo = new JvmSystemInfo();
    private final String title;
    private final LocalDateTime crawlTimestamp;
    private final UUID runId;

    ImmutableCrawlInfo(JdbcDriverInfo jdbcDriverInfo, DatabaseInfo databaseInfo, String title) {
        Objects.requireNonNull(jdbcDriverInfo, "No JDBC driver information provided");
        this.jdbcDriverInfo = new BaseProductVersion(jdbcDriverInfo);
        Objects.requireNonNull(databaseInfo, "No database information provided");
        this.databaseInfo = new BaseProductVersion(databaseInfo);
        this.title = title;
        this.crawlTimestamp = LocalDateTime.now();
        this.runId = UUID.randomUUID();
    }

    @Override
    public LocalDateTime getCrawlTimestamp() {
        return this.crawlTimestamp;
    }

    @Override
    public String getDatabaseInfo() {
        return this.databaseInfo.toString();
    }

    @Override
    public String getJdbcDriverInfo() {
        return this.jdbcDriverInfo.toString();
    }

    @Override
    public String getJvmSystemInfo() {
        return this.jvmInfo.toString();
    }

    @Override
    public String getOperatingSystemInfo() {
        return this.osInfo.toString();
    }

    @Override
    public String getRunId() {
        return this.runId.toString();
    }

    @Override
    public String getSchemaCrawlerInfo() {
        return this.schemaCrawlerInfo.toString();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String toString() {
        StringBuilder info = new StringBuilder(1024);
        info.append("-- generated by: ").append(this.schemaCrawlerInfo).append(System.lineSeparator());
        info.append("-- generated on: ").append(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(this.getCrawlTimestamp())).append(System.lineSeparator());
        info.append("-- database: ").append(this.databaseInfo).append(System.lineSeparator());
        info.append("-- driver: ").append(this.jdbcDriverInfo).append(System.lineSeparator());
        info.append("-- operating system: ").append(this.osInfo).append(System.lineSeparator());
        info.append("-- JVM system: ").append(this.jvmInfo).append(System.lineSeparator());
        return info.toString();
    }
}

