/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.ResultSet;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.crawl.ResultsRetriever;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import sf.util.SchemaCrawlerLogger;
import sf.util.StopWatch;

public final class ResultsCrawler {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(ResultsCrawler.class.getName());
    private final ResultSet results;

    public ResultsCrawler(ResultSet results) {
        this.results = Objects.requireNonNull(results, "No result-set specified");
    }

    public ResultsColumns crawl() throws SchemaCrawlerException {
        StopWatch stopWatch = new StopWatch("crawlResultSet");
        LOGGER.log(Level.INFO, "Crawling result set");
        try {
            ResultsRetriever resultsRetriever = new ResultsRetriever(this.results);
            ResultsColumns resultsColumns = stopWatch.time("retrieveResults", resultsRetriever::retrieveResults);
            LOGGER.log(Level.INFO, stopWatch.stringify());
            return resultsColumns;
        }
        catch (SchemaCrawlerSQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), e.getCause());
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Exception retrieving result-set information", e);
        }
    }
}

