/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.analysis.associations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.analysis.associations.ColumnMatchKeysMap;
import schemacrawler.analysis.associations.ForeignKeys;
import schemacrawler.analysis.associations.ProposedWeakAssociation;
import schemacrawler.analysis.associations.TableCandidateKeys;
import schemacrawler.analysis.associations.TableMatchKeys;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import us.fatehi.utility.string.StringFormat;

public final class WeakAssociationsAnalyzer {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(WeakAssociationsAnalyzer.class.getName());
    private final List<Table> tables;
    private final Collection<ProposedWeakAssociation> weakAssociations;

    public WeakAssociationsAnalyzer(Collection<Table> tables) {
        Objects.requireNonNull(tables, "No tables provided");
        this.tables = new ArrayList<Table>(tables);
        Collections.sort(this.tables);
        this.weakAssociations = new ArrayList<ProposedWeakAssociation>();
    }

    public Collection<ProposedWeakAssociation> analyzeTables() {
        if (this.tables.size() < 2) {
            return Collections.emptySet();
        }
        this.findWeakAssociations(this.tables);
        return this.weakAssociations;
    }

    private void findWeakAssociations(List<Table> tables) {
        LOGGER.log(Level.INFO, "Finding weak associations");
        ForeignKeys foreignKeys = new ForeignKeys(tables);
        ColumnMatchKeysMap columnMatchKeysMap = new ColumnMatchKeysMap(tables);
        TableMatchKeys tableMatchKeys = new TableMatchKeys(tables);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Column match keys <%s>", new Object[]{columnMatchKeysMap}));
            LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Column match keys <%s>", new Object[]{tableMatchKeys}));
        }
        for (Table table : tables) {
            TableCandidateKeys tableCandidateKeys = new TableCandidateKeys(table);
            LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Table candidate keys <%s>", new Object[]{tableCandidateKeys}));
            for (Column pkColumn : tableCandidateKeys) {
                HashSet<String> fkColumnMatchKeys = new HashSet<String>();
                if (pkColumn.isPartOfPrimaryKey()) {
                    fkColumnMatchKeys.addAll(tableMatchKeys.get(table));
                }
                if (columnMatchKeysMap.containsKey(pkColumn)) {
                    fkColumnMatchKeys.addAll(columnMatchKeysMap.get(pkColumn));
                }
                HashSet<Column> fkColumns = new HashSet<Column>();
                for (String fkColumnMatchKey : fkColumnMatchKeys) {
                    if (!columnMatchKeysMap.containsKey(fkColumnMatchKey)) continue;
                    fkColumns.addAll(columnMatchKeysMap.get(fkColumnMatchKey));
                }
                for (Column fkColumn : fkColumns) {
                    ProposedWeakAssociation proposedWeakAssociation;
                    if (pkColumn.equals(fkColumn) || !(proposedWeakAssociation = new ProposedWeakAssociation(pkColumn, fkColumn)).isValid() || foreignKeys.contains(proposedWeakAssociation)) continue;
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Found weak association <%s>", new Object[]{proposedWeakAssociation}));
                    this.weakAssociations.add(proposedWeakAssociation);
                }
            }
        }
    }
}

