/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.schema.TableTypes;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.utility.JavaSqlTypes;
import schemacrawler.utility.TypeMap;
import us.fatehi.utility.DatabaseUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class RetrieverConnection {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(RetrieverConnection.class.getName());
    private final Connection connection;
    private final JavaSqlTypes javaSqlTypes;
    private final DatabaseMetaData metaData;
    private final SchemaRetrievalOptions schemaRetrievalOptions;
    private final TableTypes tableTypes;

    RetrieverConnection(Connection connection, SchemaRetrievalOptions schemaRetrievalOptions) throws SQLException {
        this.connection = DatabaseUtility.checkConnection((Connection)connection);
        this.metaData = connection.getMetaData();
        this.schemaRetrievalOptions = Objects.requireNonNull(schemaRetrievalOptions, "No database specific overrides provided");
        this.tableTypes = TableTypes.from(connection);
        LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Supported table types are <%s>", new Object[]{this.tableTypes}));
        this.javaSqlTypes = new JavaSqlTypes();
    }

    public MetadataRetrievalStrategy get(SchemaInfoMetadataRetrievalStrategy schemaInfoMetadataRetrievalStrategy) {
        return this.schemaRetrievalOptions.get(schemaInfoMetadataRetrievalStrategy);
    }

    public Driver getDriver() throws SQLException {
        Driver jdbcDriver = null;
        String jdbcDriverClassName = this.schemaRetrievalOptions.getDatabaseServerType().getJdbcDriverClassName();
        if (!Utility.isBlank((CharSequence)jdbcDriverClassName)) {
            try {
                Class<?> jdbcDriverClass = Class.forName(jdbcDriverClassName);
                jdbcDriver = (Driver)jdbcDriverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "No JDBC driver found for " + jdbcDriverClassName, (Throwable)e);
            }
        }
        if (jdbcDriver == null) {
            jdbcDriver = DriverManager.getDriver(this.connection.getMetaData().getURL());
        }
        if (jdbcDriver == null) {
            throw new SQLException("No JDBC driver found");
        }
        return jdbcDriver;
    }

    Connection getConnection() {
        return this.connection;
    }

    EnumDataTypeHelper getEnumDataTypeHelper() {
        return this.schemaRetrievalOptions.getEnumDataTypeHelper();
    }

    InformationSchemaViews getInformationSchemaViews() {
        return this.schemaRetrievalOptions.getInformationSchemaViews();
    }

    JavaSqlTypes getJavaSqlTypes() {
        return this.javaSqlTypes;
    }

    DatabaseMetaData getMetaData() {
        return this.metaData;
    }

    TableTypes getTableTypes() {
        return this.tableTypes;
    }

    TypeMap getTypeMap() {
        return this.schemaRetrievalOptions.getTypeMap();
    }

    boolean isSupportsCatalogs() {
        return this.schemaRetrievalOptions.isSupportsCatalogs();
    }

    boolean isSupportsSchemas() {
        return this.schemaRetrievalOptions.isSupportsSchemas();
    }
}

