/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaReference;
import us.fatehi.utility.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

final class SchemaRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaRetriever.class.getName());
    private final boolean supportsCatalogs;
    private final boolean supportsSchemas;

    SchemaRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
        this.supportsCatalogs = retrieverConnection.isSupportsCatalogs();
        this.supportsSchemas = retrieverConnection.isSupportsSchemas();
    }

    void retrieveSchemas(InclusionRule schemaInclusionRule) throws SQLException {
        InclusionRuleFilter<SchemaReference> schemaFilter = new InclusionRuleFilter<SchemaReference>(schemaInclusionRule, true);
        if (schemaFilter.isExcludeAll()) {
            return;
        }
        Set<SchemaReference> schemaRefs = this.retrieveAllSchemasFromInformationSchemaViews();
        if (schemaRefs.isEmpty()) {
            schemaRefs.addAll(this.retrieveAllSchemas());
        }
        Iterator<SchemaReference> iterator = schemaRefs.iterator();
        while (iterator.hasNext()) {
            SchemaReference schemaRef = iterator.next();
            if (schemaFilter.test(schemaRef)) continue;
            LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Excluding schema <%s>", new Object[]{schemaRef}));
            iterator.remove();
        }
        for (SchemaReference schemaRef : schemaRefs) {
            this.catalog.addSchema(schemaRef);
        }
        if (!this.supportsCatalogs && !this.supportsSchemas) {
            this.catalog.addSchema(new SchemaReference(null, null));
        }
    }

    private Set<String> retrieveAllCatalogs() {
        LOGGER.log(Level.INFO, "Retrieving all catalogs");
        HashSet<String> catalogNames = new HashSet<String>();
        if (this.supportsCatalogs) {
            try {
                int numCatalogs = 0;
                List metaDataCatalogNames = DatabaseUtility.readResultsVector((ResultSet)this.getMetaData().getCatalogs());
                for (String catalogName : metaDataCatalogNames) {
                    ++numCatalogs;
                    catalogNames.add(catalogName);
                }
                LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Processed %d catalogs", new Object[]{numCatalogs}));
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), (Throwable)e);
            }
            LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieved catalogs <%s>", new Object[]{catalogNames}));
        }
        return catalogNames;
    }

    private Set<SchemaReference> retrieveAllSchemas() throws SQLException {
        LOGGER.log(Level.INFO, "Retrieving all schemas");
        HashSet<SchemaReference> schemaRefs = new HashSet<SchemaReference>();
        Set<String> allCatalogNames = this.retrieveAllCatalogs();
        if (this.supportsSchemas) {
            int numSchemas = 0;
            try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getSchemas());){
                results.setDescription("retrieveAllSchemas");
                while (results.next()) {
                    ++numSchemas;
                    String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                    String schemaName = results.getString("TABLE_SCHEM");
                    LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving schema: %s --> %s", new Object[]{catalogName, schemaName}));
                    if (catalogName == null) {
                        if (allCatalogNames.isEmpty()) {
                            schemaRefs.add(new SchemaReference(null, schemaName));
                            continue;
                        }
                        for (String expectedCatalogName : allCatalogNames) {
                            schemaRefs.add(new SchemaReference(expectedCatalogName, schemaName));
                        }
                        continue;
                    }
                    schemaRefs.add(new SchemaReference(catalogName, schemaName));
                }
            }
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Processed %d schemas", new Object[]{numSchemas}));
        } else {
            for (String catalogName : allCatalogNames) {
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving schema: %s --> %s", new Object[]{catalogName, null}));
                schemaRefs.add(new SchemaReference(catalogName, null));
            }
        }
        return schemaRefs;
    }

    private Set<SchemaReference> retrieveAllSchemasFromInformationSchemaViews() throws SQLException {
        HashSet<SchemaReference> schemaRefs = new HashSet<SchemaReference>();
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.SCHEMATA)) {
            LOGGER.log(Level.FINE, "Schemata SQL statement was not provided");
            return schemaRefs;
        }
        Query schemataSql = informationSchemaViews.getQuery(InformationSchemaKey.SCHEMATA);
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(schemataSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrieveAllSchemasFromInformationSchemaViews");
            int numSchemas = 0;
            while (results.next()) {
                ++numSchemas;
                String catalogName = results.getString("CATALOG_NAME");
                String schemaName = results.getString("SCHEMA_NAME");
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving schema: %s --> %s", new Object[]{catalogName, schemaName}));
                schemaRefs.add(new SchemaReference(catalogName, schemaName));
            }
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Processed %d schemas", new Object[]{numSchemas}));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve schemas", (Throwable)e);
        }
        return schemaRefs;
    }
}

