/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineParameter;
import schemacrawler.schemacrawler.GrepOptions;
import us.fatehi.utility.string.StringFormat;

class RoutineGrepFilter
implements Predicate<Routine> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(RoutineGrepFilter.class.getName());
    private final InclusionRule grepColumnInclusionRule;
    private final InclusionRule grepDefinitionInclusionRule;
    private final boolean invertMatch;

    public RoutineGrepFilter(GrepOptions options) {
        this.invertMatch = options.isGrepInvertMatch();
        this.grepColumnInclusionRule = options.getGrepRoutineParameterInclusionRule().orElse(null);
        this.grepDefinitionInclusionRule = options.getGrepDefinitionInclusionRule().orElse(null);
    }

    @Override
    public boolean test(Routine routine) {
        boolean include;
        boolean checkIncludeForDefinitions;
        boolean checkIncludeForColumns = this.grepColumnInclusionRule != null;
        boolean bl = checkIncludeForDefinitions = this.grepDefinitionInclusionRule != null;
        if (!checkIncludeForColumns && !checkIncludeForDefinitions) {
            return true;
        }
        boolean includeForColumns = false;
        boolean includeForDefinitions = false;
        for (RoutineParameter parameter : routine.getParameters()) {
            if (checkIncludeForColumns && this.grepColumnInclusionRule.test(parameter.getFullName())) {
                includeForColumns = true;
                break;
            }
            if (!checkIncludeForDefinitions || !this.grepDefinitionInclusionRule.test(parameter.getRemarks())) continue;
            includeForDefinitions = true;
            break;
        }
        if (checkIncludeForDefinitions) {
            if (this.grepDefinitionInclusionRule.test(routine.getRemarks())) {
                includeForDefinitions = true;
            }
            if (this.grepDefinitionInclusionRule.test(routine.getDefinition())) {
                includeForDefinitions = true;
            }
        }
        boolean bl2 = include = checkIncludeForColumns && includeForColumns || checkIncludeForDefinitions && includeForDefinitions;
        if (this.invertMatch) {
            boolean bl3 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Excluding routine <%s>", new Object[]{routine}));
        }
        return include;
    }
}

