/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.schema.Trigger;
import schemacrawler.schemacrawler.GrepOptions;
import us.fatehi.utility.string.StringFormat;

class TableGrepFilter
implements Predicate<Table> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TableGrepFilter.class.getName());
    private final InclusionRule grepColumnInclusionRule;
    private final InclusionRule grepDefinitionInclusionRule;
    private final boolean invertMatch;

    public TableGrepFilter(GrepOptions options) {
        this.invertMatch = options.isGrepInvertMatch();
        this.grepColumnInclusionRule = options.getGrepColumnInclusionRule().orElse(null);
        this.grepDefinitionInclusionRule = options.getGrepDefinitionInclusionRule().orElse(null);
    }

    @Override
    public boolean test(Table table) {
        boolean include;
        boolean checkIncludeForDefinitions;
        boolean checkIncludeForColumns = this.grepColumnInclusionRule != null;
        boolean bl = checkIncludeForDefinitions = this.grepDefinitionInclusionRule != null;
        if (!checkIncludeForColumns && !checkIncludeForDefinitions) {
            return true;
        }
        boolean includeForColumns = false;
        boolean includeForDefinitions = false;
        List<Column> columns = table.getColumns();
        if (columns.isEmpty()) {
            includeForColumns = true;
            includeForDefinitions = true;
        }
        for (Column column : columns) {
            if (checkIncludeForColumns && this.grepColumnInclusionRule.test(column.getFullName())) {
                includeForColumns = true;
                break;
            }
            if (!checkIncludeForDefinitions || !this.grepDefinitionInclusionRule.test(column.getRemarks())) continue;
            includeForDefinitions = true;
            break;
        }
        if (checkIncludeForDefinitions) {
            if (this.grepDefinitionInclusionRule.test(table.getRemarks())) {
                includeForDefinitions = true;
            }
            if (this.grepDefinitionInclusionRule.test(table.getDefinition())) {
                includeForDefinitions = true;
            }
            for (Trigger trigger : table.getTriggers()) {
                if (!this.grepDefinitionInclusionRule.test(trigger.getActionStatement())) continue;
                includeForDefinitions = true;
                break;
            }
        }
        boolean bl2 = include = checkIncludeForColumns && includeForColumns || checkIncludeForDefinitions && includeForDefinitions;
        if (this.invertMatch) {
            boolean bl3 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Excluding table <%s>", new Object[]{table}));
        }
        return include;
    }
}

