/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.schemacrawler.DatabaseObjectInfoRetrieval;
import schemacrawler.schemacrawler.InfoLevel;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoRetrieval;
import us.fatehi.utility.Utility;

public final class SchemaInfoLevelBuilder
implements OptionsBuilder<SchemaInfoLevelBuilder, SchemaInfoLevel> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaInfoLevelBuilder.class.getName());
    private final Map<SchemaInfoRetrieval, Boolean> schemaInfoRetrievals = new EnumMap<SchemaInfoRetrieval, Boolean>(SchemaInfoRetrieval.class);
    private String tag = "";

    public static SchemaInfoLevelBuilder builder() {
        return new SchemaInfoLevelBuilder();
    }

    public static SchemaInfoLevel detailed() {
        return SchemaInfoLevelBuilder.builder().withTag("detailed").withInfoLevel(InfoLevel.detailed).toOptions();
    }

    public static SchemaInfoLevel maximum() {
        return SchemaInfoLevelBuilder.builder().withTag("maximum").withInfoLevel(InfoLevel.maximum).toOptions();
    }

    public static SchemaInfoLevel minimum() {
        return SchemaInfoLevelBuilder.builder().withTag("minimum").withInfoLevel(InfoLevel.minimum).toOptions();
    }

    public static SchemaInfoLevel newSchemaInfoLevel() {
        return SchemaInfoLevelBuilder.standard();
    }

    public static SchemaInfoLevel standard() {
        return SchemaInfoLevelBuilder.builder().withTag("standard").withInfoLevel(InfoLevel.standard).toOptions();
    }

    private SchemaInfoLevelBuilder() {
    }

    public SchemaInfoLevelBuilder fromOptions(SchemaInfoLevel schemaInfoLevel) {
        if (schemaInfoLevel == null) {
            return this;
        }
        this.tag = schemaInfoLevel.getTag();
        try {
            for (SchemaInfoRetrieval schemaInfoRetrieval : SchemaInfoRetrieval.values()) {
                boolean booleanValue = schemaInfoLevel.is(schemaInfoRetrieval);
                this.schemaInfoRetrievals.put(schemaInfoRetrieval, booleanValue);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not obtain schema info level settings", (Throwable)e);
        }
        return this;
    }

    public String getTag() {
        return this.tag;
    }

    public SchemaInfoLevelBuilder setRetrieveAdditionalColumnAttributes(boolean retrieveAdditionalColumnAttributes) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveAdditionalColumnAttributes, retrieveAdditionalColumnAttributes);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveAdditionalColumnMetadata(boolean retrieveAdditionalColumnMetadata) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveAdditionalColumnMetadata, retrieveAdditionalColumnMetadata);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveAdditionalDatabaseInfo(boolean retrieveAdditionalDatabaseInfo) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveAdditionalDatabaseInfo, retrieveAdditionalDatabaseInfo);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveAdditionalJdbcDriverInfo(boolean retrieveAdditionalJdbcDriverInfo) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveAdditionalJdbcDriverInfo, retrieveAdditionalJdbcDriverInfo);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveAdditionalTableAttributes(boolean retrieveAdditionalTableAttributes) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveAdditionalTableAttributes, retrieveAdditionalTableAttributes);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveColumnDataTypes(boolean retrieveColumnDataTypes) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveColumnDataTypes, retrieveColumnDataTypes);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveDatabaseInfo(boolean retrieveDatabaseInfo) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveDatabaseInfo, retrieveDatabaseInfo);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveDatabaseUsers(boolean retrieveDatabaseUsers) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveDatabaseUsers, retrieveDatabaseUsers);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveForeignKeys(boolean retrieveForeignKeys) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveForeignKeys, retrieveForeignKeys);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveIndexes(boolean retrieveIndexes) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveIndexes, retrieveIndexes);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveIndexInformation(boolean retrieveIndexInformation) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveIndexInformation, retrieveIndexInformation);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveRoutineInformation(boolean retrieveRoutineInformation) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveRoutineInformation, retrieveRoutineInformation);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveRoutineParameters(boolean retrieveRoutineParameters) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveRoutineParameters, retrieveRoutineParameters);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveRoutines(boolean retrieveRoutines) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveRoutines, retrieveRoutines);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveSequenceInformation(boolean retrieveSequenceInformation) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveSequenceInformation, retrieveSequenceInformation);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveServerInfo(boolean retrieveServerInfo) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveServerInfo, retrieveServerInfo);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveSynonymInformation(boolean retrieveSynonymInformation) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveSynonymInformation, retrieveSynonymInformation);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTableColumnPrivileges(boolean retrieveTableColumnPrivileges) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveTableColumnPrivileges, retrieveTableColumnPrivileges);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTableColumns(boolean retrieveTableColumns) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveTableColumns, retrieveTableColumns);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTableConstraintDefinitions(boolean retrieveTableConstraintDefinitions) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveTableConstraintDefinitions, retrieveTableConstraintDefinitions);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTableConstraintInformation(boolean retrieveTableConstraintInformation) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveTableConstraintInformation, retrieveTableConstraintInformation);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTableDefinitionsInformation(boolean retrieveTableDefinitionsInformation) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveTableDefinitionsInformation, retrieveTableDefinitionsInformation);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTablePrivileges(boolean retrieveTablePrivileges) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveTablePrivileges, retrieveTablePrivileges);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTables(boolean retrieveTables) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveTables, retrieveTables);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTriggerInformation(boolean retrieveTriggerInformation) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveTriggerInformation, retrieveTriggerInformation);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveUserDefinedColumnDataTypes(boolean retrieveUserDefinedColumnDataTypes) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveUserDefinedColumnDataTypes, retrieveUserDefinedColumnDataTypes);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveViewInformation(boolean retrieveViewInformation) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveViewInformation, retrieveViewInformation);
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveWeakAssociations(boolean retrieveWeakAssociations) {
        this.schemaInfoRetrievals.put(SchemaInfoRetrieval.retrieveWeakAssociations, retrieveWeakAssociations);
        return this;
    }

    @Override
    public SchemaInfoLevel toOptions() {
        this.reduceMap();
        return new SchemaInfoLevel(this.tag, this.schemaInfoRetrievals);
    }

    public String toString() {
        return this.tag == null ? "" : this.tag;
    }

    public SchemaInfoLevelBuilder withInfoLevel(InfoLevel infoLevel) {
        if (infoLevel == null) {
            return this;
        }
        int infoLevelOrdinal = infoLevel.ordinal();
        for (SchemaInfoRetrieval schemaInfoRetrieval : SchemaInfoRetrieval.values()) {
            int schemaInfoLevelOrdinal = schemaInfoRetrieval.getInfoLevel().ordinal();
            if (schemaInfoLevelOrdinal > infoLevelOrdinal) continue;
            this.schemaInfoRetrievals.put(schemaInfoRetrieval, true);
        }
        return this;
    }

    public SchemaInfoLevelBuilder withoutRoutines() {
        return this.withoutDatabaseObjectInfoRetrieval(DatabaseObjectInfoRetrieval.routine);
    }

    public SchemaInfoLevelBuilder withoutTables() {
        return this.withoutDatabaseObjectInfoRetrieval(DatabaseObjectInfoRetrieval.table);
    }

    public SchemaInfoLevelBuilder withTag(String tag) {
        this.tag = Utility.isBlank((CharSequence)tag) ? "" : tag;
        return this;
    }

    private Boolean is(SchemaInfoRetrieval schemaInfoRetrieval) {
        if (schemaInfoRetrieval == null) {
            return false;
        }
        return this.schemaInfoRetrievals.getOrDefault((Object)schemaInfoRetrieval, false);
    }

    private void reduceMap() {
        for (SchemaInfoRetrieval schemaInfoRetrieval : SchemaInfoRetrieval.values()) {
            if (this.is(schemaInfoRetrieval).booleanValue()) continue;
            this.schemaInfoRetrievals.remove((Object)schemaInfoRetrieval);
        }
    }

    private SchemaInfoLevelBuilder withoutDatabaseObjectInfoRetrieval(DatabaseObjectInfoRetrieval databaseObjectInfoRetrieval) {
        for (SchemaInfoRetrieval schemaInfoRetrieval : SchemaInfoRetrieval.values()) {
            if (schemaInfoRetrieval.getDatabaseObjectInfoRetrieval() != databaseObjectInfoRetrieval) continue;
            this.schemaInfoRetrievals.remove((Object)schemaInfoRetrieval);
        }
        return this;
    }
}

