/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.BaseForeignKey;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Index;
import schemacrawler.schema.PartialDatabaseObject;
import schemacrawler.schema.Table;

public final class MetaDataUtility {
    public static Collection<List<String>> allIndexCoumnNames(Table table) {
        return MetaDataUtility.indexCoumnNames(table, false);
    }

    public static List<String> columnNames(Index index) {
        if (index == null) {
            return Collections.emptyList();
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column indexColumn : index) {
            columnNames.add(indexColumn.getFullName());
        }
        return columnNames;
    }

    public static String constructForeignKeyName(Column pkColumn, Column fkColumn) {
        Objects.requireNonNull(pkColumn, "No primary key column provided");
        Objects.requireNonNull(fkColumn, "No foreign key column provided");
        Table pkTable = (Table)pkColumn.getParent();
        Table fkParent = (Table)fkColumn.getParent();
        String pkHex = Integer.toHexString(pkTable.getFullName().hashCode());
        String fkHex = Integer.toHexString(fkParent.getFullName().hashCode());
        String foreignKeyName = String.format("SC_%s_%s", pkHex, fkHex).toUpperCase();
        return foreignKeyName;
    }

    public static boolean containsGeneratedColumns(Index index) {
        if (index == null) {
            return false;
        }
        for (Column indexColumn : index) {
            if (!indexColumn.isGenerated()) continue;
            return true;
        }
        return false;
    }

    public static ForeignKeyCardinality findForeignKeyCardinality(BaseForeignKey<?> foreignKey) {
        if (foreignKey == null) {
            return ForeignKeyCardinality.unknown;
        }
        boolean isForeignKeyUnique = MetaDataUtility.isForeignKeyUnique(foreignKey);
        ColumnReference columnRef0 = (ColumnReference)foreignKey.getColumnReferences().get(0);
        Column fkColumn = columnRef0.getForeignKeyColumn();
        boolean isColumnReference = fkColumn instanceof PartialDatabaseObject;
        ForeignKeyCardinality connectivity = isColumnReference ? ForeignKeyCardinality.unknown : (isForeignKeyUnique ? ForeignKeyCardinality.zero_one : ForeignKeyCardinality.zero_many);
        return connectivity;
    }

    public static List<String> foreignKeyColumnNames(BaseForeignKey<? extends ColumnReference> foreignKey) {
        if (foreignKey == null) {
            return Collections.emptyList();
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnReference columnReference : foreignKey) {
            columnNames.add(columnReference.getForeignKeyColumn().getFullName());
        }
        return columnNames;
    }

    public static boolean isForeignKeyUnique(BaseForeignKey<?> foreignKey) {
        if (foreignKey == null) {
            return false;
        }
        ColumnReference columnRef0 = (ColumnReference)foreignKey.getColumnReferences().get(0);
        Table fkTable = (Table)columnRef0.getForeignKeyColumn().getParent();
        Collection<List<String>> uniqueIndexCoumnNames = MetaDataUtility.uniqueIndexCoumnNames(fkTable);
        List<String> foreignKeyColumnNames = MetaDataUtility.foreignKeyColumnNames(foreignKey);
        return uniqueIndexCoumnNames.contains(foreignKeyColumnNames);
    }

    public static Collection<List<String>> uniqueIndexCoumnNames(Table table) {
        return MetaDataUtility.indexCoumnNames(table, true);
    }

    private static Collection<List<String>> indexCoumnNames(Table table, boolean includeUniqueOnly) {
        ArrayList<List<String>> allIndexCoumns = new ArrayList<List<String>>();
        if (table instanceof PartialDatabaseObject) {
            return allIndexCoumns;
        }
        for (Index index : table.getIndexes()) {
            if (includeUniqueOnly && !index.isUnique()) continue;
            List<String> indexColumns = MetaDataUtility.columnNames(index);
            allIndexCoumns.add(indexColumns);
        }
        return allIndexCoumns;
    }

    private MetaDataUtility() {
    }

    public static enum ForeignKeyCardinality {
        unknown(""),
        zero_one("(0..1)"),
        zero_many("(0..many)"),
        one_one("(1..1)");

        private final String description;

        private ForeignKeyCardinality(String description) {
            this.description = Objects.requireNonNull(description, "No description provided");
        }

        public String toString() {
            return this.description;
        }
    }
}

