/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.OrderingComparison;
import org.junit.jupiter.api.Test;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.TableType;
import schemacrawler.schemacrawler.SchemaReference;

public class CompareToTest {
    @Test
    public void compareTables() {
        MutableTable tbl = new MutableTable((Schema)new SchemaReference(null, "public"), "booking_detail");
        tbl.setTableType(new TableType("table"));
        MutableView view = new MutableView((Schema)new SchemaReference(null, "public"), "blog_monthly_stat_fa");
        view.setTableType(new TableType("materialized view"));
        MatcherAssert.assertThat((Object)view, (Matcher)OrderingComparison.lessThan(null));
        MatcherAssert.assertThat((Object)tbl, (Matcher)OrderingComparison.lessThan(null));
        MatcherAssert.assertThat((Object)tbl, (Matcher)OrderingComparison.comparesEqualTo((Comparable)tbl));
        MatcherAssert.assertThat((Object)view, (Matcher)OrderingComparison.comparesEqualTo((Comparable)view));
        MatcherAssert.assertThat((Object)tbl, (Matcher)OrderingComparison.lessThan((Comparable)view));
        MatcherAssert.assertThat((Object)view, (Matcher)OrderingComparison.greaterThan((Comparable)tbl));
    }

    @Test
    public void databaseObject() {
        SchemaReference schema = new SchemaReference("catalog", "schema");
        SchemaReference schema1 = new SchemaReference("catalog", "schema1");
        class TestDatabaseObject
        extends AbstractDatabaseObject {
            private static final long serialVersionUID = -7594540047157616727L;

            TestDatabaseObject(Schema schema, String name) {
                super(schema, name);
            }
        }
        TestDatabaseObject tstDbObj1 = new TestDatabaseObject((Schema)schema, "tstDbObj1");
        TestDatabaseObject tstDbObj2 = new TestDatabaseObject((Schema)schema, "tstDbObj2");
        TestDatabaseObject tstDbObj3 = new TestDatabaseObject((Schema)schema1, "tstDbObj1");
        MatcherAssert.assertThat((Object)((Object)tstDbObj1), (Matcher)OrderingComparison.lessThan(null));
        MatcherAssert.assertThat((Object)((Object)tstDbObj2), (Matcher)OrderingComparison.lessThan(null));
        MatcherAssert.assertThat((Object)((Object)tstDbObj3), (Matcher)OrderingComparison.lessThan(null));
        MatcherAssert.assertThat((Object)((Object)tstDbObj1), (Matcher)OrderingComparison.lessThan((Comparable)((Object)tstDbObj2)));
        MatcherAssert.assertThat((Object)((Object)tstDbObj2), (Matcher)OrderingComparison.greaterThan((Comparable)((Object)tstDbObj1)));
        MatcherAssert.assertThat((Object)((Object)tstDbObj1), (Matcher)OrderingComparison.lessThan((Comparable)((Object)tstDbObj3)));
        MatcherAssert.assertThat((Object)((Object)tstDbObj2), (Matcher)OrderingComparison.lessThan((Comparable)((Object)tstDbObj3)));
        MatcherAssert.assertThat((Object)((Object)tstDbObj3), (Matcher)OrderingComparison.greaterThan((Comparable)((Object)tstDbObj1)));
        MatcherAssert.assertThat((Object)((Object)tstDbObj3), (Matcher)OrderingComparison.greaterThan((Comparable)((Object)tstDbObj2)));
        MatcherAssert.assertThat((Object)((Object)tstDbObj1), (Matcher)OrderingComparison.greaterThan((Comparable)new NamedObject(){
            private static final long serialVersionUID = -1308483158535248447L;

            public int compareTo(NamedObject o) {
                return 0;
            }

            public String getFullName() {
                return "";
            }

            public String getName() {
                return "";
            }

            public NamedObjectKey key() {
                return null;
            }
        }));
    }
}

