/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.crawl.ConnectionInfoBuilder;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.ConnectionInfo;
import schemacrawler.schema.NamedObject;
import schemacrawler.test.utility.WithTestDatabase;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

@WithTestDatabase
public class CoverageTest {
    @Test
    public void connectionInfoBuilder(Connection connection) throws SQLException {
        ConnectionInfo connectionInfo = ConnectionInfoBuilder.builder((Connection)connection).build();
        MatcherAssert.assertThat((Object)connectionInfo.getConnectionUrl(), (Matcher)Matchers.matchesPattern((String)"jdbc:hsqldb:hsql://\\d*\\.\\d*\\.\\d*\\.\\d*:\\d*/schemacrawler\\d*"));
        MatcherAssert.assertThat((Object)connectionInfo.getDatabaseProductName(), (Matcher)CoreMatchers.is((Object)"HSQL Database Engine"));
        MatcherAssert.assertThat((Object)connectionInfo.getDatabaseProductVersion(), (Matcher)CoreMatchers.is((Object)"2.7.1"));
        MatcherAssert.assertThat((Object)connectionInfo.getDriverClassName(), (Matcher)CoreMatchers.is((Object)"org.hsqldb.jdbc.JDBCDriver"));
        MatcherAssert.assertThat((Object)connectionInfo.getDriverMajorVersion(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)connectionInfo.getDriverMinorVersion(), (Matcher)CoreMatchers.is((Object)7));
        MatcherAssert.assertThat((Object)connectionInfo.getDriverName(), (Matcher)CoreMatchers.is((Object)"HSQL Database Engine Driver"));
        MatcherAssert.assertThat((Object)connectionInfo.getDriverVersion(), (Matcher)CoreMatchers.is((Object)"2.7.1"));
        MatcherAssert.assertThat((Object)connectionInfo.getJdbcMajorVersion(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)connectionInfo.getJdbcMinorVersion(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)connectionInfo.getUserName(), (Matcher)CoreMatchers.is((Object)"SA"));
    }

    @Test
    public void connectionInfoBuilderException(Connection connection) throws SQLException {
        DatabaseMetaData dbMetaData2 = (DatabaseMetaData)Mockito.spy((Object)connection.getMetaData());
        Mockito.when((Object)dbMetaData2.getUserName()).thenThrow(new Throwable[]{new SQLException("Cannot get user name")});
        Connection connection2 = (Connection)Mockito.spy((Object)connection);
        Mockito.when((Object)connection2.getMetaData()).thenReturn((Object)dbMetaData2);
        ConnectionInfo connectionInfo = ConnectionInfoBuilder.builder((Connection)connection2).build();
        MatcherAssert.assertThat((Object)connectionInfo.getDriverClassName(), (Matcher)CoreMatchers.is((Object)"org.hsqldb.jdbc.JDBCDriver"));
        MatcherAssert.assertThat((Object)connectionInfo.getDriverMajorVersion(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)connectionInfo.getDriverMinorVersion(), (Matcher)CoreMatchers.is((Object)7));
        MatcherAssert.assertThat((Object)connectionInfo.getDriverName(), (Matcher)CoreMatchers.is((Object)"HSQL Database Engine Driver"));
        MatcherAssert.assertThat((Object)connectionInfo.getDriverVersion(), (Matcher)CoreMatchers.is((Object)"2.7.1"));
        MatcherAssert.assertThat((Object)connectionInfo.getUserName(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void namedObjectList() {
        NamedObjectList list = new NamedObjectList();
        list.add((NamedObject)new AbstractNamedObject("name1"){
            private static final long serialVersionUID = -514565049545540452L;
        });
        list.add((NamedObject)new AbstractNamedObject("name2"){
            private static final long serialVersionUID = 6176088733525976950L;
        });
        MatcherAssert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)list.toString(), (Matcher)Matchers.equalTo((Object)"[\"name1\", \"name2\"]"));
    }

    @Test
    public void namedObjectListNull() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            NamedObjectList list = new NamedObjectList();
            list.add(null);
        });
    }

    @Test
    public void retrieverConnection() throws SQLException {
        Assertions.assertThrows(NullPointerException.class, () -> new RetrieverConnection(null, null));
    }

    @Test
    public void retrieverConnectionClosed(DatabaseConnectionSource dataSource) {
        Assertions.assertThrows(NullPointerException.class, () -> {
            Connection connection = (Connection)dataSource.get();
            connection.close();
            new RetrieverConnection(dataSource, null);
        });
    }
}

