/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.crawl.ConnectionInfoBuilder;
import schemacrawler.crawl.DataTypeRetriever;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ConnectionInfo;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestContext;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class DataTypeRetrieverTest {
    private MutableCatalog catalog;

    private static String printColumnDataType(ColumnDataType columnDataType) {
        StringBuilder buffer = new StringBuilder();
        boolean isUserDefined = columnDataType.getType() == DataTypeType.user_defined;
        String typeName = columnDataType.getFullName();
        String dataType = (isUserDefined ? "user defined " : "") + "column data-type";
        String nullable = (columnDataType.isNullable() ? "" : "not ") + "nullable";
        String autoIncrementable = (columnDataType.isAutoIncrementable() ? "" : "not ") + "auto-incrementable";
        String createParameters = columnDataType.getCreateParameters();
        String definedWith = "defined with " + (Utility.isBlank((CharSequence)createParameters) ? "no parameters" : createParameters);
        String literalPrefix = columnDataType.getLiteralPrefix();
        String literalPrefixText = Utility.isBlank((CharSequence)literalPrefix) ? "no literal prefix" : "literal prefix " + literalPrefix;
        String literalSuffix = columnDataType.getLiteralSuffix();
        String literalSuffixText = Utility.isBlank((CharSequence)literalSuffix) ? "no literal suffix" : "literal suffix " + literalSuffix;
        String javaSqlType = "java.sql.Types: " + columnDataType.getJavaSqlType().getName();
        String precision = "precision " + columnDataType.getPrecision();
        String minimumScale = "minimum scale " + columnDataType.getMinimumScale();
        String maximumScale = "maximum scale " + columnDataType.getMaximumScale();
        buffer.append(typeName).append("\n").append("  ").append(dataType).append("\n").append("  ").append(definedWith).append("\n").append("  ").append(nullable).append("\n").append("  ").append(autoIncrementable).append("\n").append("  ").append(literalPrefixText).append("\n").append("  ").append(literalSuffixText).append("\n").append("  ").append(columnDataType.getSearchable().toString()).append("\n").append("  ").append(precision).append("\n").append("  ").append(minimumScale).append("\n").append("  ").append(maximumScale).append("\n").append("  ").append(javaSqlType).append("\n");
        if (isUserDefined) {
            ColumnDataType baseColumnDataType = columnDataType.getBaseType();
            String baseTypeName = baseColumnDataType == null ? "" : baseColumnDataType.getFullName();
            buffer.append("\n").append("  ").append("based on ").append(baseTypeName).append("\n");
        }
        buffer.append("  attributes:\n");
        TreeMap attributes = new TreeMap(columnDataType.getAttributes());
        for (Map.Entry attribute : attributes.entrySet()) {
            buffer.append("    ").append((String)attribute.getKey()).append("=").append(attribute.getValue()).append("\n");
        }
        return buffer.toString();
    }

    private static void verifyRetrieveColumnDataTypes(Catalog catalog, String expectedResultsResource) throws IOException {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            List columnDataTypes = (List)catalog.getColumnDataTypes();
            MatcherAssert.assertThat((String)"ColumnDataType count does not match", (Object)columnDataTypes, (Matcher)Matchers.hasSize((int)23));
            Collections.sort(columnDataTypes, NamedObjectSort.alphabetical);
            for (ColumnDataType columnDataType : columnDataTypes) {
                MatcherAssert.assertThat((Object)columnDataType, (Matcher)Matchers.notNullValue());
                out.println(DataTypeRetrieverTest.printColumnDataType(columnDataType));
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(expectedResultsResource)));
    }

    @BeforeAll
    public void loadBaseCatalog(Connection connection) throws SQLException {
        ConnectionInfo connectionInfo = ConnectionInfoBuilder.builder((Connection)connection).build();
        this.catalog = new MutableCatalog("datatype_test", connectionInfo);
        MatcherAssert.assertThat((Object)this.catalog.getColumnDataTypes(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.catalog.getSchemas(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.catalog.getDatabaseInfo().getServerInfo(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    @DisplayName(value="Override type info from data dictionary")
    public void overrideTypeInfoFromDataDictionary(TestContext testContext, DatabaseConnectionSource dataSource) throws Exception {
        int magicNumber = 99;
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.TYPE_INFO, String.format("SELECT %d AS INJECTED_TEST_ATTRIBUTE, TYPE_INFO.* FROM INFORMATION_SCHEMA.SYSTEM_TYPEINFO TYPE_INFO", 99)).toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder().with(SchemaInfoMetadataRetrievalStrategy.typeInfoRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all).withInformationSchemaViews(informationSchemaViews);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        DataTypeRetriever dataTypeRetriever = new DataTypeRetriever(retrieverConnection, this.catalog, options);
        dataTypeRetriever.retrieveSystemColumnDataTypes();
        DataTypeRetrieverTest.verifyRetrieveColumnDataTypes((Catalog)this.catalog, testContext.testMethodFullName());
    }

    @Test
    @DisplayName(value="System data types")
    public void systemDataTypes(TestContext testContext, DatabaseConnectionSource dataSource) throws Exception {
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, DatabaseTestUtility.schemaRetrievalOptionsDefault);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        DataTypeRetriever dataTypeRetriever = new DataTypeRetriever(retrieverConnection, this.catalog, options);
        dataTypeRetriever.retrieveSystemColumnDataTypes();
        Collection systemColumnDataTypes = this.catalog.getSystemColumnDataTypes();
        MatcherAssert.assertThat((Object)systemColumnDataTypes, (Matcher)Matchers.hasSize((int)23));
        MatcherAssert.assertThat((Object)this.catalog.getColumnDataTypes((Schema)new SchemaReference("catalog", "schema")), (Matcher)Matchers.is((Matcher)Matchers.emptyCollectionOf(ColumnDataType.class)));
        Assertions.assertThrows(NullPointerException.class, () -> this.catalog.getColumnDataTypes(null));
    }
}

