/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.crawl.ConnectionInfoBuilder;
import schemacrawler.crawl.DatabaseInfoRetriever;
import schemacrawler.crawl.ImmutableServerInfoProperty;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.ConnectionInfo;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Property;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestContext;
import schemacrawler.test.utility.WithTestDatabase;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class DatabaseInfoRetrieverTest {
    private MutableCatalog catalog;

    @Test
    @DisplayName(value="Database info")
    public void databaseInfo(TestContext testContext, Connection connection) throws Exception {
        MatcherAssert.assertThat((Object)this.catalog.getDatabaseInfo().toString(), (Matcher)Matchers.is((Object)("-- database: HSQL Database Engine 2.7.1" + System.lineSeparator())));
    }

    @Test
    @DisplayName(value="Retrieve database users")
    public void databaseUsers(TestContext testContext, DatabaseConnectionSource dataSource) throws Exception {
        MatcherAssert.assertThat((Object)this.catalog.getDatabaseUsers(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.DATABASE_USERS, "SELECT USER_NAME AS USERNAME, ADMIN, INITIAL_SCHEMA, AUTHENTICATION, PASSWORD_DIGEST FROM INFORMATION_SCHEMA.SYSTEM_USERS").toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder().withInformationSchemaViews(informationSchemaViews);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        DatabaseInfoRetriever databaseInfoRetriever = new DatabaseInfoRetriever(retrieverConnection, this.catalog, options);
        databaseInfoRetriever.retrieveDatabaseUsers();
        ArrayList databaseUsers = new ArrayList(this.catalog.getDatabaseUsers());
        MatcherAssert.assertThat(databaseUsers, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(databaseUsers.stream().map(NamedObject::getName).collect(Collectors.toList()), (Matcher)Matchers.hasItems((Object[])new String[]{"OTHERUSER", "SA"}));
        MatcherAssert.assertThat(databaseUsers.stream().map(databaseUser -> databaseUser.getAttributes().size()).collect(Collectors.toList()), (Matcher)Matchers.hasItems((Object[])new Integer[]{3, 3}));
        MatcherAssert.assertThat(databaseUsers.stream().map(databaseUser -> databaseUser.getAttributes().keySet()).flatMap(Collection::stream).collect(Collectors.toSet()), (Matcher)Matchers.hasItems((Object[])new String[]{"AUTHENTICATION", "PASSWORD_DIGEST", "ADMIN"}));
    }

    @BeforeAll
    public void loadBaseCatalog(Connection connection) throws SQLException {
        ConnectionInfo connectionInfo = ConnectionInfoBuilder.builder((Connection)connection).build();
        this.catalog = new MutableCatalog("database_info_test", connectionInfo);
        MatcherAssert.assertThat((Object)this.catalog.getColumnDataTypes(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.catalog.getSchemas(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.catalog.getDatabaseInfo().getServerInfo(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    @DisplayName(value="Retrieve server info")
    public void serverInfo(TestContext testContext, DatabaseConnectionSource dataSource) throws Exception {
        MatcherAssert.assertThat((Object)this.catalog.getDatabaseInfo().getServerInfo(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        String name = "TEST Server Info Property - Name";
        String description = "TEST Server Info Property - Description";
        String value = "TEST Server Info Property - Value";
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.SERVER_INFORMATION, String.format("SELECT '%s' AS NAME, '%s' AS DESCRIPTION, '%s' AS VALUE FROM INFORMATION_SCHEMA.SYSTEM_TYPEINFO", "TEST Server Info Property - Name", "TEST Server Info Property - Description", "TEST Server Info Property - Value")).toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder().withInformationSchemaViews(informationSchemaViews);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        DatabaseInfoRetriever databaseInfoRetriever = new DatabaseInfoRetriever(retrieverConnection, this.catalog, options);
        databaseInfoRetriever.retrieveServerInfo();
        ArrayList serverInfo = new ArrayList(this.catalog.getDatabaseInfo().getServerInfo());
        MatcherAssert.assertThat(serverInfo, (Matcher)Matchers.hasSize((int)1));
        Property serverInfoProperty = (Property)serverInfo.get(0);
        MatcherAssert.assertThat((Object)serverInfoProperty, (Matcher)Matchers.is((Object)new ImmutableServerInfoProperty("TEST Server Info Property - Name", "TEST Server Info Property - Value", "TEST Server Info Property - Description")));
        MatcherAssert.assertThat((Object)serverInfoProperty.getDescription(), (Matcher)Matchers.is((Object)"TEST Server Info Property - Description"));
    }
}

