/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.junit.jupiter.api.Test;
import schemacrawler.BaseProductVersion;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.crawl.AbstractNamedObjectWithAttributes;
import schemacrawler.crawl.AbstractProperty;
import schemacrawler.crawl.DatabaseObjectReference;
import schemacrawler.crawl.ImmutableColumnReference;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.TablePointer;
import schemacrawler.inclusionrule.ExcludeAll;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableType;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaReference;
import us.fatehi.utility.graph.DirectedEdge;
import us.fatehi.utility.graph.Vertex;

public class EqualsTest {
    @Test
    public void baseProductVersion() {
        EqualsVerifier.forClass(BaseProductVersion.class).verify();
    }

    @Test
    public void columnReference() {
        EqualsVerifier.forClass(ImmutableColumnReference.class).withIgnoredFields(new String[]{"keySequence"}).verify();
    }

    @Test
    public void databaseObject() {
        class TestDatabaseObject
        extends AbstractDatabaseObject {
            private static final long serialVersionUID = 6661972079180914099L;

            TestDatabaseObject(Schema schema, String name) {
                super(schema, name);
            }
        }
        EqualsVerifier.forClass(TestDatabaseObject.class).suppress(new Warning[]{Warning.STRICT_INHERITANCE}).withIgnoredFields(new String[]{"key", "attributeMap"}).verify();
    }

    @Test
    public void directedEdge() {
        EqualsVerifier.forClass(DirectedEdge.class).verify();
    }

    @Test
    public void grants() {
        MutableTable table1 = new MutableTable((Schema)new SchemaReference("catalog", "schema"), "table1");
        MutableTable table2 = new MutableTable((Schema)new SchemaReference("catalog", "schema"), "table2");
        MutablePrivilege privilege1 = new MutablePrivilege((DatabaseObjectReference)new TablePointer((Table)table1), "privilege1");
        MutablePrivilege privilege2 = new MutablePrivilege((DatabaseObjectReference)new TablePointer((Table)table2), "privilege2");
        EqualsVerifier.forClass(MutablePrivilege.PrivilegeGrant.class).withPrefabValues(MutablePrivilege.class, (Object)privilege1, (Object)privilege2).verify();
    }

    @Test
    public void inclusionRules() {
        EqualsVerifier.forClass(IncludeAll.class).verify();
        EqualsVerifier.forClass(ExcludeAll.class).verify();
    }

    @Test
    public void namedObject() {
        EqualsVerifier.forClass(AbstractNamedObject.class).withIgnoredFields(new String[]{"key"}).suppress(new Warning[]{Warning.STRICT_INHERITANCE}).verify();
    }

    @Test
    public void namedObjectKey() {
        EqualsVerifier.forClass(NamedObjectKey.class).withNonnullFields(new String[]{"key"}).verify();
    }

    @Test
    public void namedObjectWithAttributes() {
        EqualsVerifier.forClass(AbstractNamedObjectWithAttributes.class).withIgnoredFields(new String[]{"key", "attributeMap"}).suppress(new Warning[]{Warning.STRICT_INHERITANCE}).verify();
    }

    @Test
    public void privilege() {
        MutableTable table1 = new MutableTable((Schema)new SchemaReference("catalog", "schema"), "table1");
        MutableTable table2 = new MutableTable((Schema)new SchemaReference("catalog", "schema"), "table2");
        EqualsVerifier.forClass(MutablePrivilege.class).withIgnoredFields(new String[]{"key", "grants", "parent", "attributeMap"}).withPrefabValues(DatabaseObjectReference.class, (Object)new TablePointer((Table)table1), (Object)new TablePointer((Table)table2)).suppress(new Warning[]{Warning.STRICT_INHERITANCE}).verify();
    }

    @Test
    public void property() {
        EqualsVerifier.forClass(AbstractProperty.class).verify();
    }

    @Test
    public void schemaInfoLevel() {
        EqualsVerifier.forClass(SchemaInfoLevel.class).verify();
    }

    @Test
    public void schemaReference() {
        EqualsVerifier.forClass(SchemaReference.class).withIgnoredFields(new String[]{"key", "attributeMap"}).verify();
    }

    @Test
    public void tableType() {
        EqualsVerifier.forClass(TableType.class).verify();
    }

    @Test
    public void vertex() {
        EqualsVerifier.forClass(Vertex.class).withIgnoredFields(new String[]{"attributes"}).verify();
    }
}

