/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.IOException;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.crawl.ForeignKeyRetriever;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schemacrawler.InfoLevel;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ForeignKeyRetrieverTest {
    private MutableCatalog catalog;

    public static void verifyRetrieveForeignKeys(Catalog catalog) throws IOException {
        ForeignKeyRetrieverTest.verifyRetrieveForeignKeys(catalog, "SchemaCrawlerTest.foreignKeys");
    }

    public static void verifyRetrieveForeignKeys(Catalog catalog, String referenceFile) throws IOException {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(2))));
            for (Schema schema : schemas) {
                out.println("schema: " + schema.getFullName());
                Table[] tables = catalog.getTables(schema).toArray(new Table[0]);
                Arrays.sort(tables, NamedObjectSort.alphabetical);
                for (Table table : tables) {
                    out.println("  table: " + table.getFullName());
                    Collection foreignKeys = table.getForeignKeys();
                    for (ForeignKey foreignKey : foreignKeys) {
                        out.println("    foreign key: " + foreignKey.getName());
                        out.println("      definition: " + foreignKey.getDefinition());
                        out.println("      specific name: " + foreignKey.getSpecificName());
                        out.println("      deferrability: " + foreignKey.getDeferrability());
                        out.println("      initially deferred: " + foreignKey.isInitiallyDeferred());
                        out.println("      delete rule: " + foreignKey.getDeleteRule());
                        out.println("      update rule: " + foreignKey.getUpdateRule());
                        out.println("      referencing table: " + foreignKey.getReferencingTable());
                        out.println("      referenced table: " + foreignKey.getReferencedTable());
                        out.println("      column references: ");
                        List columnReferences = foreignKey.getColumnReferences();
                        for (ColumnReference columnReference : columnReferences) {
                            out.println("        key sequence: " + columnReference.getKeySequence());
                            out.println("          " + columnReference);
                        }
                        out.println("      table constraint: ");
                        out.println("        parent (referencing table): " + foreignKey.getParent());
                        for (TableConstraintColumn constraintColumn : foreignKey.getConstrainedColumns()) {
                            out.println("          constrained column: " + constraintColumn);
                        }
                        MatcherAssert.assertThat((Object)foreignKey.isDeferrable(), (Matcher)Matchers.is((Object)foreignKey.isInitiallyDeferred()));
                    }
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(referenceFile)));
    }

    @Test
    @DisplayName(value="Retrieve foreign keys from data dictionary")
    public void fkFromDataDictionary(DatabaseConnectionSource dataSource) throws Exception {
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.FOREIGN_KEYS, "SELECT * FROM INFORMATION_SCHEMA.SYSTEM_CROSSREFERENCE").toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.with(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all).withInformationSchemaViews(informationSchemaViews);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        ForeignKeyRetriever foreignKeyRetriever = new ForeignKeyRetriever(retrieverConnection, this.catalog, options);
        foreignKeyRetriever.retrieveForeignKeys(this.catalog.getAllTables());
        ForeignKeyRetrieverTest.verifyRetrieveForeignKeys((Catalog)this.catalog);
    }

    @BeforeAll
    public void loadBaseCatalog(Connection connection) {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT"));
        LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.builder().withInfoLevel(InfoLevel.standard).setRetrieveForeignKeys(false).toOptions());
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withLoadOptions(loadOptionsBuilder.toOptions());
        this.catalog = (MutableCatalog)DatabaseTestUtility.getCatalog(connection, DatabaseTestUtility.schemaRetrievalOptionsDefault, schemaCrawlerOptions);
        Collection tables = this.catalog.getTables();
        MatcherAssert.assertThat((Object)tables, (Matcher)Matchers.hasSize((int)13));
        for (Table table : tables) {
            MatcherAssert.assertThat((Object)table.getColumns(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
            MatcherAssert.assertThat((Object)table.getForeignKeys(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        }
    }
}

