/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import com.openpojo.reflection.PojoClass;
import com.openpojo.reflection.PojoClassFilter;
import com.openpojo.reflection.impl.PojoClassFactory;
import com.openpojo.validation.Validator;
import com.openpojo.validation.ValidatorBuilder;
import com.openpojo.validation.rule.Rule;
import com.openpojo.validation.rule.impl.EqualsAndHashCodeMatchRule;
import com.openpojo.validation.rule.impl.GetterMustExistRule;
import com.openpojo.validation.rule.impl.NoPublicFieldsExceptStaticFinalRule;
import com.openpojo.validation.rule.impl.NoStaticExceptFinalRule;
import com.openpojo.validation.rule.impl.SetterMustExistRule;
import com.openpojo.validation.test.Tester;
import com.openpojo.validation.test.impl.GetterTester;
import com.openpojo.validation.test.impl.SetterTester;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class GettersSettersTest {
    private static final int EXPECTED_CLASS_COUNT = 56;
    private static final String PACKAGE_SCHEMACRAWLER_SCHEMA = "schemacrawler.schema";

    @Test
    public void accessors() {
        List pojoClasses = PojoClassFactory.getPojoClasses((String)PACKAGE_SCHEMACRAWLER_SCHEMA, (PojoClassFilter)new FilterPackageClasses(new String[0]));
        MatcherAssert.assertThat((String)"Classes added or removed?", (Object)pojoClasses.size(), (Matcher)Matchers.is((Object)56));
        Validator validator = ValidatorBuilder.create().with(new Rule[]{new EqualsAndHashCodeMatchRule()}).with(new Rule[]{new NoStaticExceptFinalRule()}).with(new Rule[]{new NoPublicFieldsExceptStaticFinalRule()}).with(new Rule[]{new GetterMustExistRule()}).with(new Rule[]{new SetterMustExistRule()}).with(new Tester[]{new SetterTester()}).with(new Tester[]{new GetterTester()}).build();
        validator.validate(PACKAGE_SCHEMACRAWLER_SCHEMA, new PojoClassFilter[]{new FilterPackageClasses("NamedObjectKey", "JavaSqlType", "TableTypes")});
    }

    private static class FilterPackageClasses
    implements PojoClassFilter {
        private final List<String> excludeClasses;

        FilterPackageClasses(String ... excludeClasses) {
            this.excludeClasses = Arrays.asList(excludeClasses);
        }

        public boolean include(PojoClass pojoClass) {
            Class pojoClassClazz = pojoClass.getClazz();
            return !pojoClass.getName().endsWith(".package-info") && !pojoClassClazz.isEnum() && !this.excludeClasses.contains(pojoClassClazz.getSimpleName());
        }
    }
}

