/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import schemacrawler.crawl.ConnectionInfoBuilder;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableJdbcDriverInfo;
import schemacrawler.schema.ConnectionInfo;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.WithTestDatabase;

@WithTestDatabase
@ResolveTestContext
public class JdbcDriverInfoRetrieverTest {
    private MutableCatalog catalog;

    @Test
    public void jdbcDriverInfo(Connection connection) throws Exception {
        DatabaseServerType databaseServerType = new DatabaseServerType("hsqldb-1", "HyperSQL");
        this.verifyJdbcDriverInfoRetrieval(connection, databaseServerType);
    }

    @BeforeEach
    public void loadBaseCatalog(Connection connection) throws SQLException {
        ConnectionInfo connectionInfo = ConnectionInfoBuilder.builder((Connection)connection).build();
        this.catalog = new MutableCatalog("database_info_test", connectionInfo);
        MatcherAssert.assertThat((Object)this.catalog.getColumnDataTypes(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.catalog.getSchemas(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.catalog.getJdbcDriverInfo().getDriverClassName(), (Matcher)Matchers.is((Object)""));
    }

    private void verifyJdbcDriverInfoRetrieval(Connection connection, DatabaseServerType databaseServerType) throws SQLException {
        MatcherAssert.assertThat((Object)this.catalog.getJdbcDriverInfo().getDriverClassName(), (Matcher)Matchers.is((Object)""));
        MutableJdbcDriverInfo jdbcDriverInfo = this.catalog.getJdbcDriverInfo();
        MatcherAssert.assertThat((Object)jdbcDriverInfo.getProductName(), (Matcher)Matchers.is((Object)"HSQL Database Engine Driver"));
        MatcherAssert.assertThat((Object)jdbcDriverInfo.getProductVersion(), (Matcher)Matchers.is((Object)"2.7.1"));
        ArrayList driverProperties = new ArrayList(jdbcDriverInfo.getDriverProperties());
        MatcherAssert.assertThat(driverProperties, (Matcher)Matchers.hasSize((int)0));
    }
}

