/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import com.github.npathai.hamcrestopt.OptionalMatchers;
import java.sql.Connection;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.crawl.ColumnPartial;
import schemacrawler.crawl.ColumnPointer;
import schemacrawler.crawl.DatabaseObjectReference;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutableIndexColumn;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableSequence;
import schemacrawler.crawl.MutableSynonym;
import schemacrawler.crawl.MutableTrigger;
import schemacrawler.crawl.TablePartial;
import schemacrawler.crawl.TablePointer;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.Function;
import schemacrawler.schema.FunctionParameter;
import schemacrawler.schema.Index;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.ProcedureParameter;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableTypes;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestUtility;
import schemacrawler.test.utility.WithTestDatabase;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class LookupTest {
    private static final String NOTHING_AT_ALL = "NOTHING_AT_ALL";
    private Catalog catalog;

    @BeforeAll
    public void loadCatalog(Connection connection) throws Exception {
        SchemaRetrievalOptions schemaRetrievalOptions = TestUtility.newSchemaRetrievalOptions();
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT")).includeAllSynonyms().includeAllSequences().includeAllRoutines();
        LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.maximum());
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withLoadOptions(loadOptionsBuilder.toOptions());
        this.catalog = DatabaseTestUtility.getCatalog(connection, schemaRetrievalOptions, schemaCrawlerOptions);
    }

    @Test
    public void lookupCatalog() throws Exception {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        MatcherAssert.assertThat((Object)this.catalog.lookupSchema(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)this.catalog.lookupSchema(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)this.catalog.lookupSchema("PUBLIC.BOOKS"), (Matcher)OptionalMatchers.isPresentAndIs((Object)schema));
        MutableSequence sequence = new MutableSequence((Schema)schema, "PUBLISHER_ID_SEQ");
        MatcherAssert.assertThat((Object)this.catalog.lookupSequence((Schema)schema, null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)this.catalog.lookupSequence((Schema)schema, NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)this.catalog.lookupSequence((Schema)schema, "PUBLISHER_ID_SEQ"), (Matcher)OptionalMatchers.isPresentAndIs((Object)sequence));
        MutableSynonym synonym = new MutableSynonym((Schema)schema, "PUBLICATIONS");
        MatcherAssert.assertThat((Object)this.catalog.lookupSynonym((Schema)schema, null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)this.catalog.lookupSynonym((Schema)schema, NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)this.catalog.lookupSynonym((Schema)schema, "PUBLICATIONS"), (Matcher)OptionalMatchers.isPresentAndIs((Object)synonym));
        MutableColumnDataType systemColumnDataType = new MutableColumnDataType((Schema)new SchemaReference(), "VARCHAR", DataTypeType.system);
        MatcherAssert.assertThat((Object)this.catalog.lookupSystemColumnDataType(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)this.catalog.lookupSystemColumnDataType(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)this.catalog.lookupSystemColumnDataType("VARCHAR"), (Matcher)OptionalMatchers.isPresentAndIs((Object)systemColumnDataType));
        TablePartial table = new TablePartial((Schema)schema, "AUTHORS");
        MatcherAssert.assertThat((Object)this.catalog.lookupTable((Schema)schema, null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)this.catalog.lookupTable((Schema)schema, NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)this.catalog.lookupTable((Schema)schema, "AUTHORS"), (Matcher)OptionalMatchers.isPresentAndIs((Object)table));
    }

    @Test
    public void lookupColumn() throws Exception {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Table table = (Table)this.catalog.lookupTable((Schema)schema, "AUTHORS").get();
        Column column = (Column)table.lookupColumn("FIRSTNAME").get();
        MatcherAssert.assertThat((Object)column.lookupAttribute(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)column.lookupAttribute(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)column.lookupAttribute("CHAR_OCTET_LENGTH"), (Matcher)OptionalMatchers.isPresentAndIs((Object)20));
        MutablePrivilege privilege = new MutablePrivilege((DatabaseObjectReference)new ColumnPointer(column), "DELETE");
        MatcherAssert.assertThat((Object)column.lookupPrivilege(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)column.lookupPrivilege(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)column.lookupPrivilege("DELETE"), (Matcher)OptionalMatchers.isPresentAndIs((Object)privilege));
    }

    @Test
    public void lookupFunction() throws Exception {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Collection functions = this.catalog.getRoutines((Schema)schema, "CUSTOMADD");
        MatcherAssert.assertThat((Object)functions, (Matcher)Matchers.hasSize((int)2));
        Function function = (Function)functions.iterator().next();
        MatcherAssert.assertThat((Object)function.lookupAttribute(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)function.lookupAttribute(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)function.lookupAttribute("DECLARED_NUMERIC_SCALE"), (Matcher)OptionalMatchers.isPresentAndIs((Object)0L));
        MatcherAssert.assertThat((Object)function.lookupParameter(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)function.lookupParameter(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)function.lookupParameter("ONE"), (Matcher)OptionalMatchers.isPresent());
        FunctionParameter parameter = (FunctionParameter)function.lookupParameter("ONE").get();
        MatcherAssert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"ONE"));
    }

    @Test
    public void lookupIndex() throws Exception {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Table table = (Table)this.catalog.lookupTable((Schema)schema, "AUTHORS").get();
        Index index = (Index)table.lookupIndex("IDX_B_AUTHORS").get();
        MatcherAssert.assertThat((Object)index.lookupAttribute(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)index.lookupAttribute(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)index.lookupAttribute("INDEX_QUALIFIER"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"PUBLIC"));
        MutableIndexColumn column = new MutableIndexColumn(index, (Column)new ColumnPartial(table, "FIRSTNAME"));
        MatcherAssert.assertThat((Object)index.lookupColumn(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)index.lookupColumn(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)index.lookupColumn("FIRSTNAME"), (Matcher)OptionalMatchers.isPresentAndIs((Object)column));
    }

    @Test
    public void lookupProcedure() throws Exception {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Collection procedures = this.catalog.getRoutines((Schema)schema, "NEW_PUBLISHER");
        MatcherAssert.assertThat((Object)procedures, (Matcher)Matchers.hasSize((int)2));
        Procedure procedure = (Procedure)procedures.iterator().next();
        MatcherAssert.assertThat((Object)procedure.lookupAttribute(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)procedure.lookupAttribute(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)procedure.lookupAttribute("SCHEMA_LEVEL_ROUTINE"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"YES"));
        MatcherAssert.assertThat((Object)procedure.lookupParameter(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)procedure.lookupParameter(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)procedure.lookupParameter("PUBLISHER"), (Matcher)OptionalMatchers.isPresent());
        ProcedureParameter parameter = (ProcedureParameter)procedure.lookupParameter("PUBLISHER").get();
        MatcherAssert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"PUBLISHER"));
    }

    @Test
    public void lookupTable() throws Exception {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Table table = (Table)this.catalog.lookupTable((Schema)schema, "AUTHORS").get();
        MatcherAssert.assertThat((Object)table.lookupAttribute(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupAttribute(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupAttribute("REMARKS"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"Contact details for book authors"));
        ColumnPartial column = new ColumnPartial(table, "FIRSTNAME");
        MatcherAssert.assertThat((Object)table.lookupColumn(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupColumn(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupColumn("FIRSTNAME"), (Matcher)OptionalMatchers.isPresentAndIs((Object)column));
        MutableIndex index = new MutableIndex(table, "IDX_B_AUTHORS");
        MatcherAssert.assertThat((Object)table.lookupIndex(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupIndex(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupIndex("IDX_B_AUTHORS"), (Matcher)OptionalMatchers.isPresentAndIs((Object)index));
        MutablePrivilege privilege = new MutablePrivilege((DatabaseObjectReference)new TablePointer(table), "DELETE");
        MatcherAssert.assertThat((Object)table.lookupPrivilege(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupPrivilege(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupPrivilege("DELETE"), (Matcher)OptionalMatchers.isPresentAndIs((Object)privilege));
        MutableTrigger trigger = new MutableTrigger(table, "TRG_AUTHORS");
        MatcherAssert.assertThat((Object)table.lookupTrigger(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupTrigger(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupTrigger("TRG_AUTHORS"), (Matcher)OptionalMatchers.isPresentAndIs((Object)trigger));
        MatcherAssert.assertThat((Object)table.lookupForeignKey(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupForeignKey(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)((Table)this.catalog.lookupTable((Schema)schema, "BOOKAUTHORS").get()).lookupForeignKey("Z_FK_AUTHOR"), (Matcher)OptionalMatchers.isPresent());
        MatcherAssert.assertThat((Object)table.lookupTableConstraint(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupTableConstraint(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)((Table)this.catalog.lookupTable((Schema)schema, "BOOKAUTHORS").get()).lookupTableConstraint("Z_FK_AUTHOR"), (Matcher)OptionalMatchers.isPresent());
    }

    @Test
    public void lookupTableTypes(Connection connection) throws Exception {
        TableTypes tableTypes = TableTypes.from((Connection)connection);
        MatcherAssert.assertThat((Object)tableTypes.lookupTableType(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)tableTypes.lookupTableType(NOTHING_AT_ALL), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)tableTypes.lookupTableType("VIEW"), (Matcher)OptionalMatchers.isPresent());
    }
}

