/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.DayOfWeek;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.ResultsCrawler;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ResultsColumn;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.utility.BinaryData;
import us.fatehi.utility.database.DatabaseUtility;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class MetadataResultSetTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisplayName(value="Retrieve bad values from results")
    public void badValues(Connection connection) throws Exception {
        String columnName = "COLUMN1";
        try (Statement statement = connection.createStatement();){
            statement.execute("DROP TABLE IF EXISTS TABLE1");
            statement.execute("CREATE TABLE TABLE1(COLUMN1 VARCHAR(2))");
            statement.execute("INSERT INTO TABLE1(COLUMN1) VALUES('A')");
            try (MetadataResultSet results = new MetadataResultSet(DatabaseUtility.executeSql((Statement)statement, (String)"SELECT * FROM TABLE1"), "badValues");){
                while (results.next()) {
                    int value1 = results.getInt("COLUMN1", 0);
                    MatcherAssert.assertThat((Object)value1, (Matcher)CoreMatchers.is((Object)0));
                    long value2 = results.getLong("COLUMN1", 0L);
                    MatcherAssert.assertThat((Object)value2, (Matcher)CoreMatchers.is((Object)0L));
                    short value3 = results.getShort("COLUMN1", (short)0);
                    MatcherAssert.assertThat((Object)value3, (Matcher)CoreMatchers.is((Object)0));
                    BigInteger value4 = results.getBigInteger("COLUMN1");
                    MatcherAssert.assertThat((Object)value4, (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
                    String value5 = results.getString("COLUMN1");
                    MatcherAssert.assertThat((Object)value5, (Matcher)CoreMatchers.is((Object)"A"));
                    boolean value6 = results.getBoolean("COLUMN1");
                    MatcherAssert.assertThat((Object)value6, (Matcher)CoreMatchers.is((Object)false));
                    DayOfWeek value7 = (DayOfWeek)results.getEnum("COLUMN1", (Enum)DayOfWeek.MONDAY);
                    MatcherAssert.assertThat((Object)value7, (Matcher)CoreMatchers.is((Object)DayOfWeek.MONDAY));
                    List row = results.row();
                    MatcherAssert.assertThat((Object)row, (Matcher)Matchers.hasSize((int)1));
                    MatcherAssert.assertThat(row.get(0), (Matcher)CoreMatchers.is((Object)"A"));
                    String[] columnNames = results.getColumnNames();
                    MatcherAssert.assertThat((Object)columnNames, (Matcher)Matchers.arrayWithSize((int)1));
                    MatcherAssert.assertThat((Object)columnNames[0], (Matcher)CoreMatchers.is((Object)"COLUMN1"));
                }
            }
        }
        finally {
            DatabaseUtility.executeSql((Statement)connection.createStatement(), (String)"DROP TABLE IF EXISTS TABLE1");
        }
    }

    @Test
    @DisplayName(value="Retrieve boolean values from results")
    public void booleanValues(Connection connection) throws Exception {
        String column1Name = "COLUMN1";
        try (Statement statement = connection.createStatement();){
            Throwable throwable;
            MetadataResultSet results;
            String sql;
            for (String value : Arrays.asList("1", "TRUE", "True", "true", "YES", "Yes", "yes")) {
                sql = String.format("SELECT '%s' AS COLUMN1 FROM (VALUES(0))", value);
                results = new MetadataResultSet(DatabaseUtility.executeSql((Statement)statement, (String)sql), "booleanValues-true");
                throwable = null;
                try {
                    while (results.next()) {
                        boolean booleanValue = results.getBoolean("COLUMN1");
                        MatcherAssert.assertThat((String)String.format("Incorrect boolean value for '%s'", value), (Object)booleanValue, (Matcher)CoreMatchers.is((Object)true));
                    }
                }
                catch (Throwable booleanValue) {
                    throwable = booleanValue;
                    throw booleanValue;
                }
                finally {
                    if (results == null) continue;
                    if (throwable != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable booleanValue) {
                            throwable.addSuppressed(booleanValue);
                        }
                        continue;
                    }
                    results.close();
                }
            }
            for (String value : Arrays.asList("0", "FALSE", "False", "false", "NO", "No", "no", "", "unknown")) {
                sql = String.format("SELECT '%s' AS COLUMN1 FROM (VALUES(0))", value);
                results = new MetadataResultSet(DatabaseUtility.executeSql((Statement)statement, (String)sql), "booleanValues-false");
                throwable = null;
                try {
                    while (results.next()) {
                        boolean booleanValue = results.getBoolean("COLUMN1");
                        MatcherAssert.assertThat((String)String.format("Incorrect boolean value for '%s'", value), (Object)booleanValue, (Matcher)CoreMatchers.is((Object)false));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (results == null) continue;
                    if (throwable != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    results.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisplayName(value="Retrieve large object values from results")
    public void largeObjectValues(Connection connection) throws Exception {
        String columnName = "COLUMN1";
        BiConsumer<String, ResultSet> assertAll = (dataType, resultSet) -> {
            try {
                MetadataResultSet results = new MetadataResultSet(resultSet, "largeObjectValues");
                String stringValue = results.getString("COLUMN1");
                if (dataType.equals("BLOB")) {
                    MatcherAssert.assertThat((Object)stringValue, (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
                } else if (dataType.contains("BINARY")) {
                    MatcherAssert.assertThat((Object)stringValue, (Matcher)CoreMatchers.is((Object)"41"));
                } else {
                    MatcherAssert.assertThat((Object)stringValue, (Matcher)CoreMatchers.is((Object)"A"));
                }
                List row = results.row();
                MatcherAssert.assertThat((Object)row, (Matcher)Matchers.hasSize((int)1));
                Object objectValue = row.get(0);
                if (dataType.equals("BLOB")) {
                    MatcherAssert.assertThat((Object)String.valueOf(objectValue), (Matcher)CoreMatchers.is((Object)new BinaryData().toString()));
                } else if (dataType.contains("BINARY")) {
                    MatcherAssert.assertThat(objectValue, (Matcher)CoreMatchers.is((Object)new byte[]{65}));
                } else {
                    MatcherAssert.assertThat(objectValue, (Matcher)CoreMatchers.is((Object)"A"));
                }
                String[] columnNames = results.getColumnNames();
                MatcherAssert.assertThat((Object)columnNames, (Matcher)Matchers.arrayWithSize((int)1));
                MatcherAssert.assertThat((Object)columnNames[0], (Matcher)CoreMatchers.is((Object)"COLUMN1"));
                ResultsColumns resultsColumns = new ResultsCrawler(resultSet).crawl();
                ColumnDataType columnDataType = ((ResultsColumn)resultsColumns.getColumns().get(0)).getColumnDataType();
                MatcherAssert.assertThat((Object)dataType, (Matcher)Matchers.containsString((String)columnDataType.getName()));
            }
            catch (SQLException e) {
                Assertions.fail((Throwable)e);
            }
        };
        try (Statement statement = connection.createStatement();){
            for (String dataType2 : Arrays.asList("CHARACTER(1) ", "VARCHAR(1)", "CLOB", "BINARY(1)", "VARBINARY(1)", "BLOB")) {
                statement.execute("DROP TABLE IF EXISTS TABLE1");
                statement.execute(String.format("CREATE TABLE TABLE1(COLUMN1 %s)", dataType2));
                if (dataType2.contains("BINARY") || dataType2.equals("BLOB")) {
                    PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO TABLE1(COLUMN1) VALUES(?)");
                    preparedStatement.setBinaryStream(1, new ByteArrayInputStream("A".getBytes("UTF-8")));
                    preparedStatement.execute();
                } else {
                    statement.execute("INSERT INTO TABLE1(COLUMN1) VALUES('A')");
                }
                String sql = "SELECT * FROM TABLE1";
                ResultSet results = DatabaseUtility.executeSql((Statement)statement, (String)"SELECT * FROM TABLE1");
                Throwable throwable = null;
                try {
                    while (results.next()) {
                        assertAll.accept(dataType2, results);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (results == null) continue;
                    if (throwable != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    results.close();
                }
            }
        }
        finally {
            DatabaseUtility.executeSql((Statement)connection.createStatement(), (String)"DROP TABLE IF EXISTS TABLE1");
        }
    }

    @Test
    @DisplayName(value="Retrieve null values from results")
    public void nullValues(Connection connection) throws Exception {
        String column1Name = "COLUMN1";
        String column2Name = "COLUMN2";
        BiConsumer<String, MetadataResultSet> asserts = (columnName, results) -> {
            int value1 = results.getInt(columnName, 0);
            MatcherAssert.assertThat((Object)value1, (Matcher)CoreMatchers.is((Object)0));
            long value2 = results.getLong(columnName, 0L);
            MatcherAssert.assertThat((Object)value2, (Matcher)CoreMatchers.is((Object)0L));
            short value3 = results.getShort(columnName, (short)0);
            MatcherAssert.assertThat((Object)value3, (Matcher)CoreMatchers.is((Object)0));
            BigInteger value4 = results.getBigInteger(columnName);
            MatcherAssert.assertThat((Object)value4, (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
            String value5 = results.getString(columnName);
            MatcherAssert.assertThat((Object)value5, (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
            boolean value6 = results.getBoolean(columnName);
            MatcherAssert.assertThat((Object)value6, (Matcher)CoreMatchers.is((Object)false));
            DayOfWeek value7 = (DayOfWeek)results.getEnum(columnName, (Enum)DayOfWeek.MONDAY);
            MatcherAssert.assertThat((Object)value7, (Matcher)CoreMatchers.is((Object)DayOfWeek.MONDAY));
        };
        BiConsumer<String, ResultSet> assertAll = (dataType, resultSet) -> {
            try {
                MetadataResultSet results = new MetadataResultSet(resultSet, "nullValues");
                asserts.accept("COLUMN1", results);
                asserts.accept("COLUMN2", results);
                List row = results.row();
                MatcherAssert.assertThat((Object)row, (Matcher)Matchers.hasSize((int)1));
                MatcherAssert.assertThat(row.get(0), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
                String[] columnNames = results.getColumnNames();
                MatcherAssert.assertThat((Object)columnNames, (Matcher)Matchers.arrayWithSize((int)1));
                MatcherAssert.assertThat((Object)columnNames[0], (Matcher)CoreMatchers.is((Object)"COLUMN1"));
                ResultsColumns resultsColumns = new ResultsCrawler(resultSet).crawl();
                ColumnDataType columnDataType = ((ResultsColumn)resultsColumns.getColumns().get(0)).getColumnDataType();
                MatcherAssert.assertThat((Object)dataType, (Matcher)Matchers.containsString((String)columnDataType.getName()));
            }
            catch (SQLException e) {
                Assertions.fail((Throwable)e);
            }
        };
        try (Statement statement = connection.createStatement();){
            for (String dataType2 : Arrays.asList("BIT(1)", "DECIMAL", "INTEGER", "SMALLINT", "BIGINT", "DOUBLE", "DATE", "TIME", "TIMESTAMP", "CHARACTER(1) ", "VARCHAR(1)", "LONGVARCHAR", "BINARY(1)", "VARBINARY(1)", "LONGVARBINARY")) {
                String sql = String.format("SELECT CAST(NULL AS %s) AS COLUMN1 FROM (VALUES(0))", dataType2);
                ResultSet results2 = DatabaseUtility.executeSql((Statement)statement, (String)sql);
                Throwable throwable = null;
                try {
                    while (results2.next()) {
                        assertAll.accept(dataType2, results2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (results2 == null) continue;
                    if (throwable != null) {
                        try {
                            results2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    results2.close();
                }
            }
        }
    }
}

