/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Schema;
import schemacrawler.schema.TableType;
import schemacrawler.schemacrawler.SchemaReference;

public class NamedObjectTest {
    public static final TableType TABLE = new TableType("TABLE");

    @Test
    public void tableNames() {
        String[] schemaNames = new String[]{"DBO", "PUBLIC"};
        String[] tableNames = new String[]{"CUSTOMER", "CUSTOMERLIST", "INVOICE", "ITEM", "PRODUCT", "SUPPLIER"};
        NamedObjectList tables = new NamedObjectList();
        for (String schemaName : schemaNames) {
            SchemaReference schema = new SchemaReference("CATALOG", schemaName);
            for (String tableName : tableNames) {
                MutableTable table = new MutableTable((Schema)schema, tableName);
                table.setTableType(TABLE);
                tables.add((NamedObject)table);
            }
        }
        MatcherAssert.assertThat((Object)tables.size(), (Matcher)Matchers.is((Object)(schemaNames.length * tableNames.length)));
    }
}

