/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import com.github.npathai.hamcrestopt.OptionalMatchers;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import schemacrawler.crawl.ColumnPartial;
import schemacrawler.crawl.ColumnPointer;
import schemacrawler.crawl.FunctionPartial;
import schemacrawler.crawl.FunctionPointer;
import schemacrawler.crawl.ImmutableColumnReference;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableForeignKey;
import schemacrawler.crawl.MutableFunction;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.ProcedurePartial;
import schemacrawler.crawl.ProcedurePointer;
import schemacrawler.crawl.TablePartial;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Function;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schemacrawler.SchemaReference;

public class PartialsTest {
    @Test
    public void columnPartial() {
        SchemaReference schema = new SchemaReference("catalog", "schema");
        TablePartial table = new TablePartial((Schema)schema, "table");
        MutableColumn column = new MutableColumn((Table)table, "column");
        column.setAttribute("some_attribute", (Object)"some_value");
        ColumnPartial columnPartial = new ColumnPartial((Column)column);
        table.addColumn((Column)columnPartial);
        ColumnPartial columnReferenced = new ColumnPartial((Table)table, "other_column");
        columnPartial.setReferencedColumn((Column)columnReferenced);
        table.addColumn((Column)columnReferenced);
        for (String methodName : new String[]{"getColumnDataType", "getDecimalDigits", "getDefaultValue", "getOrdinalPosition", "getPrivileges", "getSize", "getType", "getWidth", "isAutoIncremented", "isGenerated", "isHidden", "isNullable", "isPartOfForeignKey", "isPartOfIndex", "isPartOfPrimaryKey", "isPartOfUniqueIndex"}) {
            Assertions.assertThrows(InvocationTargetException.class, () -> MethodUtils.invokeMethod((Object)columnPartial, (String)methodName), (String)("Testing partial method, " + methodName));
        }
        for (String methodName : new String[]{"lookupPrivilege"}) {
            Assertions.assertThrows(InvocationTargetException.class, () -> MethodUtils.invokeMethod((Object)columnPartial, (String)methodName, (Object[])new Object[]{""}), (String)("Testing partial method, " + methodName));
        }
        MatcherAssert.assertThat((Object)columnPartial.getFullName(), (Matcher)CoreMatchers.is((Object)column.getFullName()));
        MatcherAssert.assertThat((Object)columnPartial.getSchema(), (Matcher)CoreMatchers.is((Object)column.getSchema()));
        MatcherAssert.assertThat((Object)columnPartial.getAttributes(), (Matcher)CoreMatchers.is((Object)column.getAttributes()));
        MatcherAssert.assertThat((Object)columnPartial.getParent(), (Matcher)CoreMatchers.is((Object)table));
        MatcherAssert.assertThat((Object)columnPartial.getReferencedColumn(), (Matcher)CoreMatchers.is((Object)columnReferenced));
    }

    @Test
    public void columnReference() {
        SchemaReference schema = new SchemaReference("catalog", "schema");
        TablePartial table = new TablePartial((Schema)schema, "table");
        ColumnPartial columnPartial = new ColumnPartial((Table)table, "column");
        table.addColumn((Column)columnPartial);
        ColumnPointer columnReference = new ColumnPointer((Column)columnPartial);
        MatcherAssert.assertThat((Object)columnReference.get(), (Matcher)CoreMatchers.is((Object)columnPartial));
    }

    @Test
    public void functionPartial() {
        SchemaReference schema = new SchemaReference("catalog", "schema");
        MutableFunction function = new MutableFunction((Schema)schema, "function", null);
        FunctionPartial functionPartial = new FunctionPartial((Function)function);
        FunctionPointer functionReference = new FunctionPointer((Function)function);
        MatcherAssert.assertThat((Object)functionReference.get(), (Matcher)CoreMatchers.is((Object)function));
        MatcherAssert.assertThat((Object)functionPartial.getRoutineType(), (Matcher)CoreMatchers.is((Object)RoutineType.function));
        MatcherAssert.assertThat((Object)functionPartial.getRoutineType(), (Matcher)CoreMatchers.is((Object)functionPartial.getType()));
        for (String methodName : new String[]{"getDefinition", "getRoutineBodyType", "getSpecificName", "hasDefinition", "getParameters", "getReturnType"}) {
            Assertions.assertThrows(InvocationTargetException.class, () -> MethodUtils.invokeMethod((Object)functionPartial, (String)methodName), (String)("Testing partial method, " + methodName));
        }
        for (String methodName : new String[]{"lookupParameter"}) {
            Assertions.assertThrows(InvocationTargetException.class, () -> MethodUtils.invokeMethod((Object)functionPartial, (String)methodName, (Object[])new Object[]{""}), (String)("Testing partial method, " + methodName));
        }
    }

    @Test
    public void procedurePartial() {
        SchemaReference schema = new SchemaReference("catalog", "schema");
        MutableProcedure procedure = new MutableProcedure((Schema)schema, "procedure", null);
        ProcedurePartial procedurePartial = new ProcedurePartial((Procedure)procedure);
        ProcedurePointer procedureReference = new ProcedurePointer((Procedure)procedure);
        MatcherAssert.assertThat((Object)procedureReference.get(), (Matcher)CoreMatchers.is((Object)procedure));
        MatcherAssert.assertThat((Object)procedurePartial.getRoutineType(), (Matcher)CoreMatchers.is((Object)RoutineType.procedure));
        MatcherAssert.assertThat((Object)procedurePartial.getRoutineType(), (Matcher)CoreMatchers.is((Object)procedurePartial.getType()));
        for (String methodName : new String[]{"getDefinition", "getRoutineBodyType", "getSpecificName", "hasDefinition", "getParameters", "getReturnType"}) {
            Assertions.assertThrows(InvocationTargetException.class, () -> MethodUtils.invokeMethod((Object)procedurePartial, (String)methodName), (String)("Testing partial method, " + methodName));
        }
        for (String methodName : new String[]{"lookupParameter"}) {
            Assertions.assertThrows(InvocationTargetException.class, () -> MethodUtils.invokeMethod((Object)procedurePartial, (String)methodName, (Object[])new Object[]{""}), (String)("Testing partial method, " + methodName));
        }
    }

    @Test
    public void tablePartial() {
        SchemaReference schema = new SchemaReference("catalog", "schema");
        TablePartial table = new TablePartial((Schema)schema, "table");
        ColumnPartial column = new ColumnPartial((Table)table, "column");
        table.addColumn((Column)column);
        MatcherAssert.assertThat((Object)table.lookupColumn("column"), (Matcher)OptionalMatchers.isPresentAndIs((Object)column));
        MatcherAssert.assertThat((Object)table.lookupColumn("unknown_column"), (Matcher)OptionalMatchers.isEmpty());
        MutableForeignKey foreignKey = new MutableForeignKey("fk", (ColumnReference)new ImmutableColumnReference(1, (Column)column, (Column)column));
        table.addForeignKey((ForeignKey)foreignKey);
        MatcherAssert.assertThat((Object)table.lookupForeignKey("fk"), (Matcher)OptionalMatchers.isPresentAndIs((Object)foreignKey));
        MatcherAssert.assertThat((Object)table.lookupForeignKey("unknown_fk"), (Matcher)OptionalMatchers.isEmpty());
        for (String methodName : new String[]{"getColumns", "getDefinition", "getExportedForeignKeys", "getForeignKeys", "getHiddenColumns", "getImportedForeignKeys", "getIndexes", "getPrimaryKey", "getPrivileges", "getTableConstraints", "getTableType", "getTriggers", "getType", "hasDefinition", "hasPrimaryKey"}) {
            Assertions.assertThrows(InvocationTargetException.class, () -> MethodUtils.invokeMethod((Object)table, (String)methodName), (String)("Testing partial method, " + methodName));
        }
        for (String methodName : new String[]{"lookupIndex", "lookupPrivilege", "lookupTrigger"}) {
            Assertions.assertThrows(InvocationTargetException.class, () -> MethodUtils.invokeMethod((Object)table, (String)methodName, (Object[])new Object[]{""}), (String)("Testing partial method, " + methodName));
        }
        Assertions.assertThrows(InvocationTargetException.class, () -> MethodUtils.invokeMethod((Object)table, (String)"getRelatedTables", (Object[])new Object[]{TableRelationshipType.none}), (String)"Testing partial method, getRelatedTables");
    }

    @Test
    public void tablePartialAttributes() {
        SchemaReference schema = new SchemaReference("catalog", "schema");
        MutableTable table = new MutableTable((Schema)schema, "table");
        table.setAttribute("some_attribute", (Object)"some value");
        TablePartial tablePartial = new TablePartial((Table)table);
        MatcherAssert.assertThat((Object)tablePartial.getFullName(), (Matcher)CoreMatchers.is((Object)table.getFullName()));
        MatcherAssert.assertThat((Object)tablePartial.getName(), (Matcher)CoreMatchers.is((Object)table.getName()));
        MatcherAssert.assertThat((Object)tablePartial.getSchema(), (Matcher)CoreMatchers.is((Object)table.getSchema()));
        MatcherAssert.assertThat((Object)tablePartial.getAttributes(), (Matcher)CoreMatchers.is((Object)table.getAttributes()));
    }
}

