/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.IOException;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.PrimaryKeyRetriever;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class PrimaryKeyRetrieverTest {
    private MutableCatalog catalog;

    public static void verifyRetrievePrimaryKeys(Catalog catalog) throws IOException {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
            for (Schema schema : schemas) {
                Table[] tables = catalog.getTables(schema).toArray(new Table[0]);
                Arrays.sort(tables, NamedObjectSort.alphabetical);
                for (Table table : tables) {
                    out.println(table.getFullName());
                    if (!table.hasPrimaryKey()) continue;
                    PrimaryKey primaryKey = table.getPrimaryKey();
                    out.println(String.format("  primary key: %s", primaryKey.getName()));
                    out.println(String.format("    columns: %s", primaryKey.getConstrainedColumns()));
                    out.println(String.format("    constraint type: %s", primaryKey.getType()));
                    out.println(String.format("    is deferrable: %b", primaryKey.isDeferrable()));
                    out.println(String.format("    is initially deferred: %b", primaryKey.isInitiallyDeferred()));
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource("SchemaCrawlerTest.primaryKeys")));
    }

    @BeforeAll
    public void loadBaseCatalog(Connection connection) {
        LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.minimum());
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLoadOptions(loadOptionsBuilder.toOptions());
        this.catalog = (MutableCatalog)DatabaseTestUtility.getCatalog(connection, DatabaseTestUtility.schemaRetrievalOptionsDefault, schemaCrawlerOptions);
        Collection tables = this.catalog.getTables();
        MatcherAssert.assertThat((Object)tables, (Matcher)Matchers.hasSize((int)19));
        for (Table table : tables) {
            MatcherAssert.assertThat((Object)table.getIndexes(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
            MatcherAssert.assertThat((Object)table.getPrimaryKey(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    @Test
    @DisplayName(value="Retrieve primary keys from data dictionary")
    public void primaryKeysFromDataDictionary(DatabaseConnectionSource dataSource) throws Exception {
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.PRIMARY_KEYS, "SELECT * FROM INFORMATION_SCHEMA.SYSTEM_PRIMARYKEYS").toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.with(SchemaInfoMetadataRetrievalStrategy.primaryKeysRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all).withInformationSchemaViews(informationSchemaViews);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        PrimaryKeyRetriever primaryKeyRetriever = new PrimaryKeyRetriever(retrieverConnection, this.catalog, options);
        primaryKeyRetriever.retrievePrimaryKeys(this.catalog.getAllTables());
        Collection tables = this.catalog.getTables();
        MatcherAssert.assertThat((Object)tables, (Matcher)Matchers.hasSize((int)19));
        for (Table table : tables) {
            if (Arrays.asList("Global Counts", "AUTHORSLIST", "BOOKAUTHORS", "PUBLICATIONWRITERS", "SALES", "SALESDATA").contains(table.getName())) continue;
            MatcherAssert.assertThat((String)("Did not find primary key for " + table.getFullName()), (Object)table.getPrimaryKey(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        }
    }
}

