/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.RoutineRetriever;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionInclusionRule;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineType;
import schemacrawler.schemacrawler.InfoLevel;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestContext;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class RoutineRetrieverProceduresTest {
    private MutableCatalog catalog;

    @BeforeAll
    public void loadBaseCatalog(Connection connection) {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionInclusionRule(".*\\.BOOKS"));
        LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.builder().withInfoLevel(InfoLevel.minimum).setRetrieveRoutines(false).toOptions());
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withLoadOptions(loadOptionsBuilder.toOptions());
        this.catalog = (MutableCatalog)DatabaseTestUtility.getCatalog(connection, DatabaseTestUtility.schemaRetrievalOptionsDefault, schemaCrawlerOptions);
        MatcherAssert.assertThat((Object)this.catalog.getRoutines(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    @DisplayName(value="Retrieve procedures from data dictionary")
    public void proceduresFromDataDictionary(TestContext testContext, DatabaseConnectionSource dataSource) throws Exception {
        TestWriter testout;
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.PROCEDURES, "SELECT * FROM INFORMATION_SCHEMA.SYSTEM_PROCEDURES").toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.with(SchemaInfoMetadataRetrievalStrategy.proceduresRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all).withInformationSchemaViews(informationSchemaViews);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        RoutineRetriever procedureRetriever = new RoutineRetriever(retrieverConnection, this.catalog, options);
        procedureRetriever.retrieveRoutines(Arrays.asList(RoutineType.procedure), (InclusionRule)new IncludeAll());
        try (TestWriter out = testout = new TestWriter();){
            Routine[] procedures = this.catalog.getRoutines().toArray(new Routine[0]);
            Arrays.sort(procedures, NamedObjectSort.alphabetical);
            for (Routine procedure : procedures) {
                out.println(String.format("%s (%s) [%s]", procedure.getFullName(), procedure.getSpecificName(), procedure.getRoutineType()));
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }
}

