/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import com.github.npathai.hamcrestopt.OptionalMatchers;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mockito.Mockito;
import schemacrawler.crawl.MutableFunction;
import schemacrawler.crawl.MutableTableConstraint;
import schemacrawler.crawl.SchemaCrawler;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexColumnSortSequence;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Reducer;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.ObjectPropertyTestUtility;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestUtility;
import schemacrawler.test.utility.WithTestDatabase;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSourceUtility;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class SchemaCrawlerCoverageTest {
    private Catalog catalog;

    @Test
    public void catalogReduce() throws Exception {
        Reducer reducer = (Reducer)Mockito.spy(Reducer.class);
        this.catalog.reduce(Catalog.class, reducer);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{reducer});
        Assertions.assertThrows(NullPointerException.class, () -> this.catalog.reduce(null, reducer));
        Assertions.assertThrows(NullPointerException.class, () -> this.catalog.reduce(Table.class, null));
    }

    @Test
    public void columnDataTypeProperties() throws Exception {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Table table = (Table)this.catalog.lookupTable((Schema)schema, "AUTHORS").get();
        Column column = (Column)table.lookupColumn("FIRSTNAME").get();
        ColumnDataType columnDataType = column.getColumnDataType();
        ObjectPropertyTestUtility.checkBooleanProperties(columnDataType, "autoIncrementable", "caseSensitive", "fixedPrecisionScale", "nullable", "unsigned");
    }

    @Test
    public void columnProperties() throws Exception {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Table table = (Table)this.catalog.lookupTable((Schema)schema, "AUTHORS").get();
        Column column = (Column)table.lookupColumn("FIRSTNAME").get();
        ObjectPropertyTestUtility.checkBooleanProperties(column, "autoIncremented", "generated", "hidden");
    }

    @Test
    public void coverIndexColumn() {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Table table = (Table)this.catalog.lookupTable((Schema)schema, "AUTHORS").get();
        Index index = (Index)table.lookupIndex("IDX_B_AUTHORS").get();
        IndexColumn indexColumn = (IndexColumn)index.getColumns().get(0);
        Column column = (Column)table.lookupColumn(indexColumn.getName()).get();
        this.compareColumnFields((Column)indexColumn, column);
        MatcherAssert.assertThat((Object)indexColumn.getIndex(), (Matcher)CoreMatchers.is((Object)index));
        MatcherAssert.assertThat((Object)indexColumn.getIndexOrdinalPosition(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)indexColumn.getSortSequence(), (Matcher)CoreMatchers.is((Object)IndexColumnSortSequence.ascending));
    }

    @Test
    public void coverTableConstraintColumn() {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Table table = (Table)this.catalog.lookupTable((Schema)schema, "AUTHORS").get();
        TableConstraint tableConstraint = (TableConstraint)new ArrayList(table.getTableConstraints()).get(0);
        TableConstraintColumn tableConstraintColumn = (TableConstraintColumn)tableConstraint.getConstrainedColumns().get(0);
        Column column = (Column)table.lookupColumn(tableConstraintColumn.getName()).get();
        this.compareColumnFields((Column)tableConstraintColumn, column);
        MatcherAssert.assertThat((Object)tableConstraintColumn.getTableConstraint(), (Matcher)CoreMatchers.is((Object)tableConstraint));
        MatcherAssert.assertThat((Object)tableConstraintColumn.getTableConstraintOrdinalPosition(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void getRoutines() throws Exception {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        MutableFunction routine1 = new MutableFunction((Schema)schema, "NEW_PUBLISHER", "NEW_PUBLISHER_FORCE_VALUE");
        MutableFunction routine2 = new MutableFunction((Schema)schema, "NEW_PUBLISHER", "NEW_PUBLISHER_10160");
        MatcherAssert.assertThat((Object)this.catalog.getRoutines((Schema)schema, "NEW_PUBLISHER"), (Matcher)Matchers.containsInAnyOrder((Object[])new Routine[]{routine1, routine2}));
        MatcherAssert.assertThat((Object)this.catalog.getRoutines((Schema)schema), (Matcher)CoreMatchers.hasItem((Object)routine1));
        MatcherAssert.assertThat((Object)this.catalog.getRoutines((Schema)schema), (Matcher)CoreMatchers.hasItem((Object)routine2));
        MatcherAssert.assertThat((Object)this.catalog.getRoutines(), (Matcher)CoreMatchers.hasItem((Object)routine1));
        MatcherAssert.assertThat((Object)this.catalog.getRoutines(), (Matcher)CoreMatchers.hasItem((Object)routine2));
    }

    @Test
    public void indexProperties() throws Exception {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Table table = (Table)this.catalog.lookupTable((Schema)schema, "AUTHORS").get();
        Index index = (Index)table.lookupIndex("IDX_B_AUTHORS").get();
        ObjectPropertyTestUtility.checkIntegerProperties(index, "cardinality", "pages");
        ObjectPropertyTestUtility.checkBooleanProperties(index, "unique");
    }

    @Test
    public void jdbcDriverInfoProperties() throws Exception {
        JdbcDriverInfo jdbcDriverInfo = this.catalog.getJdbcDriverInfo();
        ObjectPropertyTestUtility.checkBooleanProperties(jdbcDriverInfo, "jdbcCompliant");
        MatcherAssert.assertThat((Object)jdbcDriverInfo.toString(), (Matcher)Matchers.matchesPattern((Pattern)Pattern.compile("-- driver: HSQL Database Engine Driver 2.7.1\\R-- driver class: org.hsqldb.jdbc.JDBCDriver\\R-- url: jdbc:hsqldb:hsql:\\/\\/0.0.0.0:\\d*/schemacrawler\\d*\\R-- jdbc compliant: false", 32)));
    }

    @BeforeAll
    public void loadCatalog(Connection connection) throws Exception {
        SchemaRetrievalOptions schemaRetrievalOptions = TestUtility.newSchemaRetrievalOptions();
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT")).includeAllSynonyms().includeAllSequences().includeAllRoutines();
        LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.maximum());
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withLoadOptions(loadOptionsBuilder.toOptions());
        this.catalog = DatabaseTestUtility.getCatalog(connection, schemaRetrievalOptions, schemaCrawlerOptions);
    }

    @Test
    public void primaryKey() throws Exception {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Table table = (Table)this.catalog.lookupTable((Schema)schema, "AUTHORS").get();
        PrimaryKey primaryKey = table.getPrimaryKey();
        MatcherAssert.assertThat((Object)primaryKey.getFullName(), (Matcher)CoreMatchers.is((Object)"PUBLIC.BOOKS.AUTHORS.PK_AUTHORS"));
        MatcherAssert.assertThat((Object)primaryKey.getConstrainedColumns().toString(), (Matcher)CoreMatchers.is((Object)"[PUBLIC.BOOKS.AUTHORS.ID]"));
        MatcherAssert.assertThat((Object)primaryKey.getType(), (Matcher)CoreMatchers.is((Object)TableConstraintType.primary_key));
        MatcherAssert.assertThat((Object)primaryKey.isDeferrable(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)primaryKey.isInitiallyDeferred(), (Matcher)CoreMatchers.is((Object)false));
        MutableTableConstraint constraint = new MutableTableConstraint(table, primaryKey.getName());
        Optional optionalTableConstraint = table.lookupTableConstraint(primaryKey.getName());
        MatcherAssert.assertThat((Object)optionalTableConstraint, (Matcher)OptionalMatchers.isPresentAndIs((Object)constraint));
    }

    @Test
    public void schemaCrawlerExceptions() throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData databaseMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)connection.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)databaseMetaData);
        Mockito.when((Object)databaseMetaData.getDatabaseProductName()).thenReturn((Object)"databaseProductName");
        Mockito.when((Object)databaseMetaData.getDatabaseProductVersion()).thenReturn((Object)"databaseProductVersion");
        Mockito.when((Object)databaseMetaData.getURL()).thenReturn((Object)"connectionUrl");
        Mockito.when((Object)databaseMetaData.getDriverName()).thenReturn((Object)"driverName");
        Mockito.when((Object)databaseMetaData.getDriverVersion()).thenReturn((Object)"driverVersion");
        DatabaseConnectionSource dataSource = DatabaseConnectionSourceUtility.newTestDatabaseConnectionSource(connection);
        SchemaCrawler schemaCrawler = new SchemaCrawler(dataSource, DatabaseTestUtility.schemaRetrievalOptionsDefault, schemaCrawlerOptions);
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> schemaCrawler.crawl());
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.endsWith((String)"Cannot use null results"));
    }

    @Test
    public void sequenceProperties() throws Exception {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Sequence sequence = (Sequence)this.catalog.lookupSequence((Schema)schema, "PUBLISHER_ID_SEQ").get();
        ObjectPropertyTestUtility.checkBooleanProperties(sequence, "cycle");
    }

    @Test
    public void tableAttributes() throws Exception {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Table table = (Table)this.catalog.lookupTable((Schema)schema, "AUTHORS").get();
        MatcherAssert.assertThat((Object)table.hasAttribute("unknown"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)table.lookupAttribute("unknown"), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.getAttribute("unknown", (Object)"no value"), (Matcher)CoreMatchers.is((Object)"no value"));
        MatcherAssert.assertThat((Object)table.getAttribute("unknown", (Object)Float.valueOf(10.5f)), (Matcher)CoreMatchers.is((Object)Float.valueOf(10.5f)));
        MatcherAssert.assertThat((Object)table.hasAttribute("new_one"), (Matcher)CoreMatchers.is((Object)false));
        table.setAttribute("new_one", (Object)"some_value");
        MatcherAssert.assertThat((Object)table.getAttribute("new_one", (Object)""), (Matcher)CoreMatchers.is((Object)"some_value"));
        table.setAttribute("new_one", null);
        MatcherAssert.assertThat((Object)table.hasAttribute("new_one"), (Matcher)CoreMatchers.is((Object)false));
        table.setAttribute("new_one", (Object)"some_value");
        MatcherAssert.assertThat((Object)table.hasAttribute("new_one"), (Matcher)CoreMatchers.is((Object)true));
        table.removeAttribute("new_one");
        MatcherAssert.assertThat((Object)table.hasAttribute("new_one"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void viewProperties() throws Exception {
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        View view = (View)this.catalog.lookupTable((Schema)schema, "AUTHORSLIST").get();
        ObjectPropertyTestUtility.checkBooleanProperties(view, "updatable");
    }

    private void compareColumnFields(Column wrappedColumn, Column column) {
        MatcherAssert.assertThat((Object)wrappedColumn.getFullName(), (Matcher)CoreMatchers.is((Object)column.getFullName()));
        MatcherAssert.assertThat((Object)wrappedColumn.getColumnDataType(), (Matcher)CoreMatchers.is((Object)column.getColumnDataType()));
        MatcherAssert.assertThat((Object)wrappedColumn.getDecimalDigits(), (Matcher)CoreMatchers.is((Object)column.getDecimalDigits()));
        MatcherAssert.assertThat((Object)wrappedColumn.getOrdinalPosition(), (Matcher)CoreMatchers.is((Object)column.getOrdinalPosition()));
        MatcherAssert.assertThat((Object)wrappedColumn.getSize(), (Matcher)CoreMatchers.is((Object)column.getSize()));
        MatcherAssert.assertThat((Object)wrappedColumn.getWidth(), (Matcher)CoreMatchers.is((Object)column.getWidth()));
        MatcherAssert.assertThat((Object)wrappedColumn.isNullable(), (Matcher)CoreMatchers.is((Object)column.isNullable()));
        MatcherAssert.assertThat((Object)wrappedColumn.getDefaultValue(), (Matcher)CoreMatchers.is((Object)column.getDefaultValue()));
        MatcherAssert.assertThat((Object)wrappedColumn.getPrivileges(), (Matcher)CoreMatchers.is((Object)column.getPrivileges()));
        MatcherAssert.assertThat((Object)wrappedColumn.isAutoIncremented(), (Matcher)CoreMatchers.is((Object)column.isAutoIncremented()));
        MatcherAssert.assertThat((Object)wrappedColumn.isGenerated(), (Matcher)CoreMatchers.is((Object)column.isGenerated()));
        MatcherAssert.assertThat((Object)wrappedColumn.isHidden(), (Matcher)CoreMatchers.is((Object)column.isHidden()));
        MatcherAssert.assertThat((Object)wrappedColumn.isPartOfForeignKey(), (Matcher)CoreMatchers.is((Object)column.isPartOfForeignKey()));
        MatcherAssert.assertThat((Object)wrappedColumn.isPartOfIndex(), (Matcher)CoreMatchers.is((Object)column.isPartOfIndex()));
        MatcherAssert.assertThat((Object)wrappedColumn.isPartOfPrimaryKey(), (Matcher)CoreMatchers.is((Object)column.isPartOfPrimaryKey()));
        MatcherAssert.assertThat((Object)wrappedColumn.isPartOfUniqueIndex(), (Matcher)CoreMatchers.is((Object)column.isPartOfUniqueIndex()));
        MatcherAssert.assertThat((Object)wrappedColumn.getType(), (Matcher)CoreMatchers.is((Object)column.getType()));
    }
}

