/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableForeignKey;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTrigger;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Index;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.Trigger;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.WithTestDatabase;

@WithTestDatabase
public class SchemaCrawlerDeepTest {
    @Test
    public void tableEquals(Connection connection) throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
        SchemaReference systemSchema = new SchemaReference("PUBLIC", "SYSTEM_LOBS");
        MatcherAssert.assertThat((String)"Should not find any tables", (Object)catalog.getTables((Schema)systemSchema), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((String)"Expected no routines, since routine retrieval is turned off by default", (Object)catalog.getRoutines((Schema)systemSchema), (Matcher)Matchers.empty());
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        MatcherAssert.assertThat((String)"Could not find any tables", (Object)catalog.getTables((Schema)schema), (Matcher)Matchers.hasSize((int)10));
        MatcherAssert.assertThat((String)"Expected no routines, since routine retrieval is turned off by default", (Object)catalog.getRoutines((Schema)schema), (Matcher)Matchers.empty());
        Table table0 = (Table)catalog.getTables((Schema)schema).toArray()[0];
        MatcherAssert.assertThat((String)"Could not find any columns", (Object)table0.getColumns(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MutableTable table1 = new MutableTable(table0.getSchema(), "Test Table 1");
        MutableTable table2 = new MutableTable(table0.getSchema(), "Test Table 2");
        MutablePrimaryKey primaryKey = (MutablePrimaryKey)table0.getPrimaryKey();
        table1.setPrimaryKey(primaryKey);
        table2.setPrimaryKey(primaryKey);
        for (Column column : table0.getColumns()) {
            table1.addColumn((MutableColumn)column);
            table2.addColumn((MutableColumn)column);
        }
        for (Index index : table0.getIndexes()) {
            table1.addIndex((MutableIndex)index);
            table2.addIndex((MutableIndex)index);
        }
        for (ForeignKey fk : table0.getForeignKeys()) {
            table1.addForeignKey((MutableForeignKey)fk);
            table2.addForeignKey((MutableForeignKey)fk);
        }
        for (Trigger trigger : table0.getTriggers()) {
            table1.addTrigger((MutableTrigger)trigger);
            table2.addTrigger((MutableTrigger)trigger);
        }
        for (Privilege privilege : table0.getPrivileges()) {
            table1.addPrivilege((MutablePrivilege)privilege);
            table2.addPrivilege((MutablePrivilege)privilege);
        }
        for (TableConstraint tableConstraint : table0.getTableConstraints()) {
            table1.addTableConstraint(tableConstraint);
            table2.addTableConstraint(tableConstraint);
        }
        MatcherAssert.assertThat((String)"Tables should not be equal", (Object)table1, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)table2)));
    }
}

