/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import com.github.npathai.hamcrestopt.OptionalMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import schemacrawler.schemacrawler.SchemaReference;

public class SchemaReferenceTest {
    @Test
    public void schemaRef() {
        MatcherAssert.assertThat((Object)new SchemaReference("catalog", "schema").getFullName(), (Matcher)Matchers.is((Object)"catalog.schema"));
        MatcherAssert.assertThat((Object)new SchemaReference(null, "schema").getFullName(), (Matcher)Matchers.is((Object)"schema"));
        MatcherAssert.assertThat((Object)new SchemaReference("catalog", null).getFullName(), (Matcher)Matchers.is((Object)"catalog"));
    }

    @Test
    public void schemaRefAttributes() {
        String KEY = "name";
        String VALUE = "value";
        String OTHER_KEY = "othername";
        SchemaReference schemaReference = new SchemaReference("catalog", "schema");
        schemaReference.setAttribute("name", (Object)"value");
        MatcherAssert.assertThat((Object)schemaReference.getAttributes(), (Matcher)Matchers.hasEntry((Object)"name", (Object)"value"));
        MatcherAssert.assertThat((Object)schemaReference.getAttribute("name"), (Matcher)Matchers.is((Object)"value"));
        MatcherAssert.assertThat((Object)schemaReference.getAttribute("othername"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)schemaReference.getAttribute("othername", (Object)1), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)schemaReference.lookupAttribute("name"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"value"));
        MatcherAssert.assertThat((Object)schemaReference.lookupAttribute("othername"), (Matcher)OptionalMatchers.isEmpty());
        schemaReference.removeAttribute("othername");
        MatcherAssert.assertThat((Object)schemaReference.getAttributes(), (Matcher)Matchers.hasEntry((Object)"name", (Object)"value"));
        schemaReference.removeAttribute("name");
        MatcherAssert.assertThat((Object)schemaReference.getAttributes(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Object)"name", (Object)"value")));
    }

    @Test
    @DisplayName(value="Remarks are not supported for schemas, but test to enforce expected behavior")
    public void schemaRefRemarks() {
        String REMARKS = "remarks";
        SchemaReference schemaReference = new SchemaReference("catalog", "schema");
        schemaReference.setAttribute("name", (Object)"value");
        MatcherAssert.assertThat((Object)schemaReference.hasRemarks(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)schemaReference.getRemarks(), (Matcher)Matchers.is((Object)""));
        schemaReference.setRemarks("remarks");
        MatcherAssert.assertThat((Object)schemaReference.hasRemarks(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)schemaReference.getRemarks(), (Matcher)Matchers.is((Object)""));
    }
}

