/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import schemacrawler.crawl.ConnectionInfoBuilder;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.SchemaRetriever;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.ConnectionInfo;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.WithTestDatabase;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSourceUtility;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={MockitoExtension.class})
public class SchemaRetrieverTest {
    @Test
    @DisplayName(value="Verify that schemas can be obtained from INFORMATION_SCHEMA")
    public void schemataView(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Connection spyConnection = (Connection)Mockito.spy((Object)connection);
        Mockito.when((Object)spyConnection.getMetaData()).thenReturn((Object)databaseMetaData);
        Mockito.when((Object)databaseMetaData.getDatabaseProductName()).thenReturn((Object)"databaseProductName");
        Mockito.when((Object)databaseMetaData.getDatabaseProductVersion()).thenReturn((Object)"databaseProductVersion");
        Mockito.when((Object)databaseMetaData.getURL()).thenReturn((Object)"connectionUrl");
        Mockito.when((Object)databaseMetaData.getDriverName()).thenReturn((Object)"driverName");
        Mockito.when((Object)databaseMetaData.getDriverVersion()).thenReturn((Object)"driverVersion");
        ConnectionInfo connectionInfo = ConnectionInfoBuilder.builder((Connection)connection).build();
        MutableCatalog catalog = new MutableCatalog("test_catalog", connectionInfo);
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.SCHEMATA, "SELECT * FROM INFORMATION_SCHEMA.SCHEMATA").toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.withInformationSchemaViews(informationSchemaViews);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        DatabaseConnectionSource dataSource = DatabaseConnectionSourceUtility.newTestDatabaseConnectionSource(spyConnection);
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        SchemaRetriever schemaRetriever = new SchemaRetriever(retrieverConnection, catalog, options);
        schemaRetriever.retrieveSchemas((InclusionRule)new IncludeAll());
        ((DatabaseMetaData)Mockito.verify((Object)databaseMetaData, (VerificationMode)Mockito.times((int)0))).getSchemas();
        MatcherAssert.assertThat(schemaRetriever.getAllSchemas().values().stream().map(SchemaReference::getFullName).collect(Collectors.toList()), (Matcher)CoreMatchers.is(Arrays.asList("PUBLIC.BOOKS", "PUBLIC.FOR_LINT", "PUBLIC.INFORMATION_SCHEMA", "PUBLIC.PUBLIC", "PUBLIC.\"PUBLISHER SALES\"", "PUBLIC.SYSTEM_LOBS")));
    }
}

