/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.crawl.ForeignKeyRetriever;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.PrimaryKeyRetriever;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.TableColumnRetriever;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.InfoLevel;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TableColumnRetrieverTest {
    private MutableCatalog catalog;

    public static void verifyRetrieveTableColumns(Catalog catalog) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
            for (Schema schema : schemas) {
                Table[] tables = catalog.getTables(schema).toArray(new Table[0]);
                Arrays.sort(tables, NamedObjectSort.alphabetical);
                for (Table table : tables) {
                    Object[] columns = table.getColumns().toArray(new Column[0]);
                    Arrays.sort(columns);
                    for (Object column : columns) {
                        out.println(String.format("%s", column.getFullName()));
                        out.println(String.format("  - %s=%s", "short name", column.getShortName()));
                        out.println(String.format("  - %s=%s", "data-type", column.getColumnDataType()));
                        out.println(String.format("  - %s=%s", "size", column.getSize()));
                        out.println(String.format("  - %s=%s", "decimal digits", column.getDecimalDigits()));
                        out.println(String.format("  - %s=%s", "width", column.getWidth()));
                        out.println(String.format("  - %s=%s", "default value", column.getDefaultValue()));
                        out.println(String.format("  - %s=%s", "auto-incremented", column.isAutoIncremented()));
                        out.println(String.format("  - %s=%s", "nullable", column.isNullable()));
                        out.println(String.format("  - %s=%s", "generated", column.isGenerated()));
                        out.println(String.format("  - %s=%s", "hidden", column.isHidden()));
                        out.println(String.format("  - %s=%s", "part of primary key", column.isPartOfPrimaryKey()));
                        out.println(String.format("  - %s=%s", "part of foreign key", column.isPartOfForeignKey()));
                        out.println(String.format("  - %s=%s", "ordinal position", column.getOrdinalPosition()));
                        out.println(String.format("  - %s=%s", "remarks", column.getRemarks()));
                        out.println(String.format("  - %s=%s", "attibutes", ""));
                        TreeMap columnAttributes = new TreeMap(column.getAttributes());
                        for (Map.Entry columnAttribute : columnAttributes.entrySet()) {
                            out.println(String.format("    ~ %s=%s", columnAttribute.getKey(), columnAttribute.getValue()));
                        }
                        MatcherAssert.assertThat((Object)column.getType(), (Matcher)Matchers.is((Object)column.getColumnDataType()));
                    }
                    out.println();
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource("SchemaCrawlerTest.tableColumns")));
    }

    @Test
    @DisplayName(value="Retrieve hidden table columns from data dictionary")
    public void hiddenTableColumns(DatabaseConnectionSource dataSource) throws Exception {
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.TABLE_COLUMNS, IOUtility.readResourceFully((String)"/TABLE_COLUMNS.sql")).withSql(InformationSchemaKey.EXT_HIDDEN_TABLE_COLUMNS, IOUtility.readResourceFully((String)"/EXT_HIDDEN_TABLE_COLUMNS.sql")).toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.with(SchemaInfoMetadataRetrievalStrategy.tableColumnsRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all).withInformationSchemaViews(informationSchemaViews);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        TableColumnRetriever tableColumnRetriever = new TableColumnRetriever(retrieverConnection, this.catalog, options);
        tableColumnRetriever.retrieveTableColumns(this.catalog.getAllTables(), (InclusionRule)new IncludeAll());
        int columnCount = 0;
        int hiddenColumnCount = 0;
        for (Table table : this.catalog.getTables()) {
            Column[] columns;
            for (Column column : columns = table.getColumns().toArray(new Column[0])) {
                ++columnCount;
                if (!column.isHidden()) continue;
                ++hiddenColumnCount;
            }
        }
        MatcherAssert.assertThat((Object)columnCount, (Matcher)Matchers.is((Object)53));
        MatcherAssert.assertThat((Object)hiddenColumnCount, (Matcher)Matchers.is((Object)1));
    }

    @BeforeAll
    public void loadBaseCatalog(Connection connection) {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT"));
        LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.builder().withInfoLevel(InfoLevel.standard).setRetrieveTableColumns(false).setRetrieveForeignKeys(false).toOptions());
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withLoadOptions(loadOptionsBuilder.toOptions());
        this.catalog = (MutableCatalog)DatabaseTestUtility.getCatalog(connection, DatabaseTestUtility.schemaRetrievalOptionsDefault, schemaCrawlerOptions);
        Collection tables = this.catalog.getTables();
        MatcherAssert.assertThat((Object)tables, (Matcher)Matchers.hasSize((int)13));
        for (Table table : tables) {
            MatcherAssert.assertThat((Object)table.getColumns(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
            MatcherAssert.assertThat((Object)table.getForeignKeys(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
            MatcherAssert.assertThat((Object)table.getPrimaryKey(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    @Test
    @DisplayName(value="Retrieve table columns from data dictionary")
    public void tableColumnsFromDataDictionary(DatabaseConnectionSource dataSource) throws Exception {
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.TABLE_COLUMNS, IOUtility.readResourceFully((String)"/TABLE_COLUMNS.sql")).toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.with(SchemaInfoMetadataRetrievalStrategy.tableColumnsRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all).withInformationSchemaViews(informationSchemaViews);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        TableColumnRetriever tableColumnRetriever = new TableColumnRetriever(retrieverConnection, this.catalog, options);
        tableColumnRetriever.retrieveTableColumns(this.catalog.getAllTables(), (InclusionRule)new IncludeAll());
        ForeignKeyRetriever foreignKeyRetriever = new ForeignKeyRetriever(retrieverConnection, this.catalog, options);
        foreignKeyRetriever.retrieveForeignKeys(this.catalog.getAllTables());
        PrimaryKeyRetriever primaryKeyRetriever = new PrimaryKeyRetriever(retrieverConnection, this.catalog, options);
        primaryKeyRetriever.retrievePrimaryKeys(this.catalog.getAllTables());
        TableColumnRetrieverTest.verifyRetrieveTableColumns((Catalog)this.catalog);
    }
}

