/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.TableConstraintRetriever;
import schemacrawler.crawl.TableExtRetriever;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.plugin.EnumDataTypeInfo;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.WithTestDatabase;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TableExtRetrieverTest {
    private MutableCatalog catalog;

    @Test
    @DisplayName(value="Retrieve enum data types")
    public void enumDataTypes(DatabaseConnectionSource dataSource) throws Exception {
        EnumDataTypeHelper enumDataTypeHelper = (column, columnDataType, databaseConnection) -> {
            String columnDataTypeName;
            switch (columnDataTypeName = columnDataType.getName()) {
                case "NAME_TYPE": {
                    EnumDataTypeInfo enumDataTypeType = new EnumDataTypeInfo(EnumDataTypeInfo.EnumDataTypeTypes.enumerated_data_type, Arrays.asList("Moe", "Larry", "Curly"));
                    MatcherAssert.assertThat((Object)enumDataTypeType.toString(), (Matcher)Matchers.is((Object)"EnumDataTypeInfo [enumerated_data_type, [Moe, Larry, Curly]]"));
                    return enumDataTypeType;
                }
                case "AGE_TYPE": {
                    EnumDataTypeInfo enumColumnType = new EnumDataTypeInfo(EnumDataTypeInfo.EnumDataTypeTypes.enumerated_column, Arrays.asList("1", "16", "29"));
                    MatcherAssert.assertThat((Object)enumColumnType.toString(), (Matcher)Matchers.is((Object)"EnumDataTypeInfo [enumerated_column, [1, 16, 29]]"));
                    return enumColumnType;
                }
            }
            MatcherAssert.assertThat((Object)EnumDataTypeInfo.EMPTY_ENUM_DATA_TYPE_INFO.toString(), (Matcher)Matchers.is((Object)"EnumDataTypeInfo [not_enumerated, []]"));
            return EnumDataTypeInfo.EMPTY_ENUM_DATA_TYPE_INFO;
        };
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.withEnumDataTypeHelper(enumDataTypeHelper);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        TableExtRetriever tableExtRetriever = new TableExtRetriever(retrieverConnection, this.catalog, options);
        tableExtRetriever.retrieveAdditionalColumnMetadata();
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Collection tables = this.catalog.getTables();
        MatcherAssert.assertThat((Object)tables, (Matcher)Matchers.hasSize((int)19));
        Table table = (Table)this.catalog.lookupTable((Schema)schema, "CUSTOMERS").orElseThrow(IllegalAccessException::new);
        Column id = (Column)table.lookupColumn("ID").orElseThrow(IllegalAccessException::new);
        ColumnDataType idDataType = id.getColumnDataType();
        ColumnDataType idDataTypeMain = (ColumnDataType)this.catalog.lookupColumnDataType((Schema)new SchemaReference(), idDataType.getName()).orElseThrow(IllegalAccessException::new);
        MatcherAssert.assertThat((Object)(idDataType == idDataTypeMain ? 1 : 0), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)idDataType.isEnumerated(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)idDataType.getEnumValues(), (Matcher)Matchers.is((Object)Collections.EMPTY_LIST));
        Column firstName = (Column)table.lookupColumn("FIRSTNAME").orElseThrow(IllegalAccessException::new);
        ColumnDataType firstNameDataType = firstName.getColumnDataType();
        ColumnDataType firstNameDataTypeMain = (ColumnDataType)this.catalog.lookupColumnDataType((Schema)schema, firstNameDataType.getName()).orElseThrow(IllegalAccessException::new);
        MatcherAssert.assertThat((Object)(firstNameDataType == firstNameDataTypeMain ? 1 : 0), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)firstNameDataType.isEnumerated(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)firstNameDataType.getEnumValues(), (Matcher)Matchers.is(Arrays.asList("Moe", "Larry", "Curly")));
        Column age = (Column)table.lookupColumn("AGE").orElseThrow(IllegalAccessException::new);
        ColumnDataType ageDataType = age.getColumnDataType();
        ColumnDataType ageDataTypeMain = (ColumnDataType)this.catalog.lookupColumnDataType((Schema)schema, ageDataType.getName()).orElseThrow(IllegalAccessException::new);
        MatcherAssert.assertThat((Object)(ageDataType == ageDataTypeMain ? 1 : 0), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)ageDataType.isEnumerated(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)ageDataType.getEnumValues(), (Matcher)Matchers.is(Arrays.asList("1", "16", "29")));
        MatcherAssert.assertThat((Object)ageDataTypeMain.isEnumerated(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)ageDataTypeMain.getEnumValues(), (Matcher)Matchers.is((Object)Collections.EMPTY_LIST));
    }

    @Test
    @DisplayName(value="Retrieve index definitions from INFORMATION_SCHEMA")
    public void indexInfo(DatabaseConnectionSource dataSource) throws Exception {
        String remarks = "TEST Index remarks";
        String definition = "TEST Index definition";
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.EXT_INDEXES, String.format("SELECT DISTINCT TABLE_CAT AS INDEX_CATALOG, TABLE_SCHEM AS INDEX_SCHEMA, TABLE_NAME, INDEX_NAME, '%s' AS REMARKS, '%s' AS INDEX_DEFINITION FROM INFORMATION_SCHEMA.SYSTEM_INDEXINFO", "TEST Index remarks", "TEST Index definition")).toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.withInformationSchemaViews(informationSchemaViews);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        TableExtRetriever tableExtRetriever = new TableExtRetriever(retrieverConnection, this.catalog, options);
        tableExtRetriever.retrieveIndexInformation();
        Collection tables = this.catalog.getTables();
        MatcherAssert.assertThat((Object)tables, (Matcher)Matchers.hasSize((int)19));
        for (Table table : tables) {
            for (Index index : table.getIndexes()) {
                MatcherAssert.assertThat((Object)index.getRemarks(), (Matcher)Matchers.is((Object)"TEST Index remarks"));
                MatcherAssert.assertThat((Object)index.getDefinition(), (Matcher)Matchers.is((Object)"TEST Index definition"));
            }
        }
    }

    @BeforeAll
    public void loadBaseCatalog(Connection connection) {
        this.catalog = (MutableCatalog)DatabaseTestUtility.getCatalog(connection, DatabaseTestUtility.schemaRetrievalOptionsDefault, SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions());
        Collection tables = this.catalog.getTables();
        MatcherAssert.assertThat((Object)tables, (Matcher)Matchers.hasSize((int)19));
        for (Table table : tables) {
            for (Index index : table.getIndexes()) {
                List columns = index.getColumns();
                MatcherAssert.assertThat((Object)columns, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
                for (IndexColumn column : columns) {
                    MatcherAssert.assertThat((Object)column.isGenerated(), (Matcher)Matchers.is((Object)false));
                }
            }
        }
    }

    @Test
    @DisplayName(value="Retrieve table constraint definitions from INFORMATION_SCHEMA")
    public void tableConstraintInfo(DatabaseConnectionSource dataSource) throws Exception {
        String remarks = "TEST Table Constraint remarks";
        String definition = "TEST Table Constraint definition";
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.EXT_TABLE_CONSTRAINTS, String.format("SELECT DISTINCT CONSTRAINT_CATALOG, CONSTRAINT_SCHEMA, TABLE_NAME, CONSTRAINT_NAME, '%s' AS REMARKS, '%s' AS CONSTRAINT_DEFINITION FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS", "TEST Table Constraint remarks", "TEST Table Constraint definition")).toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.withInformationSchemaViews(informationSchemaViews);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        TableConstraintRetriever tableExtRetriever = new TableConstraintRetriever(retrieverConnection, this.catalog, options);
        tableExtRetriever.retrieveTableConstraintInformation();
        Collection tables = this.catalog.getTables();
        MatcherAssert.assertThat((Object)tables, (Matcher)Matchers.hasSize((int)19));
        for (Table table : tables) {
            for (TableConstraint constraint : table.getTableConstraints()) {
                if (constraint instanceof ForeignKey) continue;
                MatcherAssert.assertThat((String)String.format("<%s> remarks do not match expected", constraint), (Object)constraint.getRemarks(), (Matcher)Matchers.is((Object)"TEST Table Constraint remarks"));
                MatcherAssert.assertThat((Object)constraint.getDefinition(), (Matcher)Matchers.is((Object)""));
            }
        }
    }

    @Test
    @DisplayName(value="Retrieve table definitions from INFORMATION_SCHEMA")
    public void tableDefinitions(DatabaseConnectionSource dataSource) throws Exception {
        String definition = "TEST Table definition";
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.EXT_TABLES, String.format("SELECT DISTINCT TABLE_CAT AS TABLE_CATALOG, TABLE_SCHEM AS TABLE_SCHEMA, TABLE_NAME, '%s' AS TABLE_DEFINITION FROM INFORMATION_SCHEMA.SYSTEM_TABLES", "TEST Table definition")).toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.withInformationSchemaViews(informationSchemaViews);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        TableExtRetriever tableExtRetriever = new TableExtRetriever(retrieverConnection, this.catalog, options);
        tableExtRetriever.retrieveTableDefinitions();
        Collection tables = this.catalog.getTables();
        MatcherAssert.assertThat((Object)tables, (Matcher)Matchers.hasSize((int)19));
        for (Table table : tables) {
            MatcherAssert.assertThat((Object)table.getDefinition(), (Matcher)Matchers.is((Object)"TEST Table definition"));
        }
    }

    @Test
    @DisplayName(value="Retrieve view table usage from INFORMATION_SCHEMA")
    public void viewTableUsage(DatabaseConnectionSource dataSource) throws Exception {
        Collection tables = this.catalog.getTables();
        int viewCount = 0;
        MatcherAssert.assertThat((Object)tables, (Matcher)Matchers.hasSize((int)19));
        for (Table table : tables) {
            if (!(table instanceof View)) continue;
            ++viewCount;
            View view = (View)table;
            MatcherAssert.assertThat((Object)view.getTableUsage(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        }
        MatcherAssert.assertThat((Object)viewCount, (Matcher)Matchers.is((Object)1));
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.VIEW_TABLE_USAGE, "SELECT VIEW_CATALOG, VIEW_SCHEMA, VIEW_NAME, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.VIEW_TABLE_USAGE").toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.withInformationSchemaViews(informationSchemaViews);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        TableExtRetriever tableExtRetriever = new TableExtRetriever(retrieverConnection, this.catalog, options);
        tableExtRetriever.retrieveViewTableUsage();
        viewCount = 0;
        MatcherAssert.assertThat((Object)tables, (Matcher)Matchers.hasSize((int)19));
        for (Table table : tables) {
            if (!(table instanceof View)) continue;
            ++viewCount;
            View view = (View)table;
            MatcherAssert.assertThat((Object)view.getTableUsage(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        }
        MatcherAssert.assertThat((Object)viewCount, (Matcher)Matchers.is((Object)1));
    }
}

