/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.TablePrivilegeRetriever;
import schemacrawler.schema.Column;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.WithTestDatabase;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TablePrivilegeRetrieverTest {
    private MutableCatalog catalog;

    @Test
    @DisplayName(value="Retrieve column privileges without metadata retrieval strategy")
    public void columnPrivilegesBadMetadataRetrievalStrategy(DatabaseConnectionSource dataSource) throws Exception {
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.TABLE_COLUMN_PRIVILEGES, "<<bad sql>>").toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.withInformationSchemaViews(informationSchemaViews).with(SchemaInfoMetadataRetrievalStrategy.tableColumnPrivilegesRetrievalStrategy, MetadataRetrievalStrategy.none);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        TablePrivilegeRetriever tablePrivilegeRetriever = new TablePrivilegeRetriever(retrieverConnection, this.catalog, options);
        tablePrivilegeRetriever.retrieveTableColumnPrivileges();
        Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
        Table table = (Table)this.catalog.lookupTable(schemas[0], "AUTHORS").get();
        Column column = (Column)table.lookupColumn("FIRSTNAME").get();
        MatcherAssert.assertThat((Object)column.getPrivileges(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    @DisplayName(value="Retrieve column privileges without query")
    public void columnPrivilegesFromDataDictionaryWithoutQuery(DatabaseConnectionSource dataSource) throws Exception {
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.with(SchemaInfoMetadataRetrievalStrategy.tableColumnPrivilegesRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        TablePrivilegeRetriever tablePrivilegeRetriever = new TablePrivilegeRetriever(retrieverConnection, this.catalog, options);
        Assertions.assertThrows(ExecutionRuntimeException.class, () -> tablePrivilegeRetriever.retrieveTableColumnPrivileges());
    }

    @Test
    @DisplayName(value="Retrieve column privileges from metadata")
    public void columnPrivilegesFromMetadata(DatabaseConnectionSource dataSource) throws Exception {
        SchemaRetrievalOptions schemaRetrievalOptions = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        TablePrivilegeRetriever tablePrivilegeRetriever = new TablePrivilegeRetriever(retrieverConnection, this.catalog, options);
        tablePrivilegeRetriever.retrieveTableColumnPrivileges();
        Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
        Table table = (Table)this.catalog.lookupTable(schemas[0], "AUTHORS").get();
        Column column = (Column)table.lookupColumn("FIRSTNAME").get();
        MatcherAssert.assertThat((String)"HyperSQL does not support retrieving column privileges from metadata", (Object)column.getPrivileges(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @BeforeAll
    public void loadBaseCatalog(DatabaseConnectionSource dataSource) throws Exception {
        try (Connection connection = (Connection)dataSource.get();){
            this.catalog = (MutableCatalog)DatabaseTestUtility.getCatalog(connection, DatabaseTestUtility.schemaRetrievalOptionsDefault, SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions());
            Collection tables = this.catalog.getTables();
            MatcherAssert.assertThat((Object)tables, (Matcher)Matchers.hasSize((int)19));
            for (Table table : tables) {
                for (Index index : table.getIndexes()) {
                    List columns = index.getColumns();
                    MatcherAssert.assertThat((Object)columns, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
                    for (IndexColumn column : columns) {
                        MatcherAssert.assertThat((Object)column.isGenerated(), (Matcher)Matchers.is((Object)false));
                    }
                }
            }
        }
    }

    @Test
    @DisplayName(value="Retrieve table privileges without metadata retrieval strategy")
    public void tablePrivilegesBadMetadataRetrievalStrategy(DatabaseConnectionSource dataSource) throws Exception {
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.TABLE_PRIVILEGES, "<<bad sql>>").toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.withInformationSchemaViews(informationSchemaViews).with(SchemaInfoMetadataRetrievalStrategy.tablePrivilegesRetrievalStrategy, MetadataRetrievalStrategy.none);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
        Table table = (Table)this.catalog.lookupTable(schemas[0], "AUTHORS").get();
        MatcherAssert.assertThat((Object)table.getPrivileges(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        TablePrivilegeRetriever tablePrivilegeRetriever = new TablePrivilegeRetriever(retrieverConnection, this.catalog, options);
        tablePrivilegeRetriever.retrieveTablePrivileges();
        MatcherAssert.assertThat((Object)table.getPrivileges(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    @DisplayName(value="Retrieve table privileges from data dictionary")
    public void tablePrivilegesFromDataDictionary(DatabaseConnectionSource dataSource) throws Exception {
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.TABLE_PRIVILEGES, "SELECT TABLE_CATALOG AS TABLE_CAT, TABLE_SCHEMA AS TABLE_SCHEM, TABLE_NAME, GRANTOR, GRANTEE, PRIVILEGE_TYPE AS PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES").toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.withInformationSchemaViews(informationSchemaViews).with(SchemaInfoMetadataRetrievalStrategy.tablePrivilegesRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
        Table table = (Table)this.catalog.lookupTable(schemas[0], "AUTHORS").get();
        MatcherAssert.assertThat((Object)table.getPrivileges(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        TablePrivilegeRetriever tablePrivilegeRetriever = new TablePrivilegeRetriever(retrieverConnection, this.catalog, options);
        tablePrivilegeRetriever.retrieveTablePrivileges();
        MatcherAssert.assertThat((Object)table.getPrivileges(), (Matcher)Matchers.hasSize((int)6));
    }

    @Test
    @DisplayName(value="Retrieve table privileges without query")
    public void tablePrivilegesFromDataDictionaryWithoutQuery(DatabaseConnectionSource dataSource) throws Exception {
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.with(SchemaInfoMetadataRetrievalStrategy.tablePrivilegesRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        TablePrivilegeRetriever tablePrivilegeRetriever = new TablePrivilegeRetriever(retrieverConnection, this.catalog, options);
        Assertions.assertThrows(ExecutionRuntimeException.class, () -> tablePrivilegeRetriever.retrieveTablePrivileges());
    }
}

