/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.TableRetriever;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableTypes;
import schemacrawler.schemacrawler.InfoLevel;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestContext;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TableRetrieverTest {
    private MutableCatalog catalog;

    @BeforeAll
    public void loadBaseCatalog(Connection connection) {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT"));
        LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.builder().withInfoLevel(InfoLevel.minimum).setRetrieveTables(false).toOptions());
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withLoadOptions(loadOptionsBuilder.toOptions());
        this.catalog = (MutableCatalog)DatabaseTestUtility.getCatalog(connection, DatabaseTestUtility.schemaRetrievalOptionsDefault, schemaCrawlerOptions);
        Collection tables = this.catalog.getTables();
        MatcherAssert.assertThat((Object)tables, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    @DisplayName(value="Retrieve tables from data dictionary")
    public void tablesFromDataDictionary(TestContext testContext, DatabaseConnectionSource dataSource) throws Exception {
        TestWriter testout;
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.TABLES, "SELECT * FROM INFORMATION_SCHEMA.SYSTEM_TABLES").toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder();
        schemaRetrievalOptionsBuilder.with(SchemaInfoMetadataRetrievalStrategy.tablesRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all).withInformationSchemaViews(informationSchemaViews);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        RetrieverConnection retrieverConnection = new RetrieverConnection(dataSource, schemaRetrievalOptions);
        SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        TableRetriever tableRetriever = new TableRetriever(retrieverConnection, this.catalog, options);
        tableRetriever.retrieveTables("", TableTypes.from((String[])new String[]{"TABLE", "VIEW"}), (InclusionRule)new IncludeAll());
        try (TestWriter out = testout = new TestWriter();){
            Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
            for (Schema schema : schemas) {
                Table[] tables = this.catalog.getTables(schema).toArray(new Table[0]);
                Arrays.sort(tables, NamedObjectSort.alphabetical);
                for (Table table : tables) {
                    out.println(String.format("%s [%s]", table.getFullName(), table.getTableType()));
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }
}

