/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.sql.Connection;
import java.util.function.BiConsumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;

public class InformationSchemaViewsBuilderTest {
    @Test
    public void builderFromOptions() {
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES, "SOME SQL SELECT").toOptions();
        InformationSchemaViews informationSchemaViews2 = InformationSchemaViewsBuilder.builder((InformationSchemaViews)informationSchemaViews).toOptions();
        MatcherAssert.assertThat((Object)informationSchemaViews2.getQuery(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES).getQuery(), (Matcher)CoreMatchers.is((Object)"SOME SQL SELECT"));
    }

    @Test
    public void fromResourceFolder() {
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().fromResourceFolder(null).toOptions();
        MatcherAssert.assertThat((Object)informationSchemaViews.size(), (Matcher)CoreMatchers.is((Object)0));
        informationSchemaViews = InformationSchemaViewsBuilder.builder().fromResourceFolder("/").toOptions();
        MatcherAssert.assertThat((Object)informationSchemaViews.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void newOptions() {
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.newInformationSchemaViews();
        MatcherAssert.assertThat((Object)informationSchemaViews.size(), (Matcher)CoreMatchers.is((Object)0));
        informationSchemaViews = InformationSchemaViewsBuilder.builder().fromOptions(null).toOptions();
        MatcherAssert.assertThat((Object)informationSchemaViews.size(), (Matcher)CoreMatchers.is((Object)0));
        informationSchemaViews = InformationSchemaViewsBuilder.builder().fromResourceFolder(null).toOptions();
        MatcherAssert.assertThat((Object)informationSchemaViews.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void substituteAll() {
        String sql = "SOME SQL SELECT";
        InformationSchemaViewsBuilder builder = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES, "SOME SQL SELECT").withSql(InformationSchemaKey.ADDITIONAL_TABLE_ATTRIBUTES, "SOME ${key} SUBSTITUTE SQL SELECT");
        builder.substituteAll("key", "value");
        MatcherAssert.assertThat(builder.toOptions().getAllInformationSchemaViews().get(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES), (Matcher)CoreMatchers.is((Object)"SOME SQL SELECT"));
        MatcherAssert.assertThat(builder.toOptions().getAllInformationSchemaViews().get(InformationSchemaKey.ADDITIONAL_TABLE_ATTRIBUTES), (Matcher)CoreMatchers.is((Object)"SOME value SUBSTITUTE SQL SELECT"));
    }

    @Test
    public void withFunction() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        InformationSchemaViewsBuilder builder = InformationSchemaViewsBuilder.builder();
        BiConsumer<InformationSchemaViewsBuilder, Connection> function = (bldr, conn) -> {
            throw new RuntimeException("Forced exception");
        };
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> builder.withFunction(function, connection));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"Forced exception"));
        Assertions.assertDoesNotThrow(() -> builder.withFunction(null, connection));
    }

    @Test
    public void withSql() {
        InformationSchemaViewsBuilder builder = InformationSchemaViewsBuilder.builder();
        String sql = "SOME SQL SELECT";
        builder.withSql(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES, "SOME SQL SELECT");
        MatcherAssert.assertThat(builder.toOptions().getAllInformationSchemaViews().get(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES), (Matcher)CoreMatchers.is((Object)"SOME SQL SELECT"));
        builder.withSql(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES, null);
        MatcherAssert.assertThat(builder.toOptions().getAllInformationSchemaViews().get(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
    }
}

