/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import com.github.npathai.hamcrestopt.OptionalMatchers;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import schemacrawler.plugin.EnumDataTypeInfo;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.utility.TypeMap;

public class SchemaRetrievalOptionsBuilderTest {
    @Test
    public void connectionInitializer() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        SchemaRetrievalOptionsBuilder builder = SchemaRetrievalOptionsBuilder.builder();
        builder.connectionInitializer.accept(connection);
        Mockito.verifyNoInteractions((Object[])new Object[]{connection});
        builder.withConnectionInitializer(conn -> {
            throw new RuntimeException("Test forced exception");
        });
        RuntimeException runtimeException1 = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> builder.connectionInitializer.accept(connection));
        MatcherAssert.assertThat((Object)runtimeException1.getMessage(), (Matcher)CoreMatchers.is((Object)"Test forced exception"));
        builder.withConnectionInitializer(null);
        builder.connectionInitializer.accept(connection);
        Mockito.verifyNoInteractions((Object[])new Object[]{connection});
    }

    @Test
    public void dbMetaData() throws SQLException {
        DatabaseMetaData dbMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)dbMetaData.supportsCatalogsInTableDefinitions()).thenReturn((Object)false);
        Mockito.when((Object)dbMetaData.supportsSchemasInTableDefinitions()).thenReturn((Object)true);
        Mockito.when((Object)dbMetaData.getIdentifierQuoteString()).thenReturn((Object)"@");
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)dbMetaData);
        SchemaRetrievalOptionsBuilder builder = SchemaRetrievalOptionsBuilder.builder();
        MatcherAssert.assertThat((Object)builder.supportsCatalogs, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.supportsSchemas, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)builder.identifierQuoteString, (Matcher)CoreMatchers.is((Object)""));
        builder.fromConnnection(connection);
        MatcherAssert.assertThat((Object)builder.supportsCatalogs, (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)builder.supportsSchemas, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isPresent());
        MatcherAssert.assertThat((Object)builder.identifierQuoteString, (Matcher)CoreMatchers.is((Object)"@"));
    }

    @Test
    public void dbMetaData_none() throws SQLException {
        SchemaRetrievalOptionsBuilder builder = SchemaRetrievalOptionsBuilder.builder();
        MatcherAssert.assertThat((Object)builder.supportsCatalogs, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.supportsSchemas, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isEmpty());
        builder.fromConnnection(null);
        MatcherAssert.assertThat((Object)builder.supportsCatalogs, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.supportsSchemas, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isEmpty());
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.getMetaData()).thenThrow(SQLException.class);
        builder = SchemaRetrievalOptionsBuilder.builder();
        MatcherAssert.assertThat((Object)builder.supportsCatalogs, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.supportsSchemas, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isEmpty());
        builder.fromConnnection(connection);
        MatcherAssert.assertThat((Object)builder.supportsCatalogs, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.supportsSchemas, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isPresent());
    }

    @Test
    public void dbMetaData_overrides() throws SQLException {
        DatabaseMetaData dbMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)dbMetaData.supportsCatalogsInTableDefinitions()).thenReturn((Object)false);
        Mockito.when((Object)dbMetaData.supportsSchemasInTableDefinitions()).thenReturn((Object)true);
        Mockito.when((Object)dbMetaData.getIdentifierQuoteString()).thenReturn((Object)"#");
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)dbMetaData);
        SchemaRetrievalOptionsBuilder builder = SchemaRetrievalOptionsBuilder.builder();
        builder.withSupportsCatalogs();
        builder.withSupportsSchemas();
        builder.withIdentifierQuoteString("@");
        MatcherAssert.assertThat((Object)builder.supportsCatalogs, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.overridesSupportsCatalogs, (Matcher)OptionalMatchers.isPresentAndIs((Object)true));
        MatcherAssert.assertThat((Object)builder.supportsSchemas, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.overridesSupportsSchemas, (Matcher)OptionalMatchers.isPresentAndIs((Object)true));
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)builder.identifierQuoteString, (Matcher)CoreMatchers.is((Object)"@"));
        builder.fromConnnection(connection);
        MatcherAssert.assertThat((Object)builder.supportsCatalogs, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.overridesSupportsCatalogs, (Matcher)OptionalMatchers.isPresentAndIs((Object)true));
        MatcherAssert.assertThat((Object)builder.supportsSchemas, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.overridesSupportsSchemas, (Matcher)OptionalMatchers.isPresentAndIs((Object)true));
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isPresent());
        MatcherAssert.assertThat((Object)builder.identifierQuoteString, (Matcher)CoreMatchers.is((Object)"@"));
        builder = SchemaRetrievalOptionsBuilder.builder();
        builder.withTypeMap(new HashMap());
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isPresent());
        builder.fromConnnection(connection);
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isPresent());
        Mockito.when((Object)dbMetaData.getIdentifierQuoteString()).thenReturn((Object)"\t");
        builder = SchemaRetrievalOptionsBuilder.builder();
        builder.fromConnnection(connection);
        MatcherAssert.assertThat((Object)builder.identifierQuoteString, (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void dbServerType() {
        SchemaRetrievalOptionsBuilder builder = SchemaRetrievalOptionsBuilder.builder();
        MatcherAssert.assertThat((Object)builder.dbServerType, (Matcher)CoreMatchers.is((Object)DatabaseServerType.UNKNOWN));
        builder.withDatabaseServerType(new DatabaseServerType("newdb", "New Database"));
        MatcherAssert.assertThat((Object)builder.dbServerType.getDatabaseSystemIdentifier(), (Matcher)CoreMatchers.is((Object)"newdb"));
        builder.withDatabaseServerType(null);
        MatcherAssert.assertThat((Object)builder.dbServerType, (Matcher)CoreMatchers.is((Object)DatabaseServerType.UNKNOWN));
    }

    @Test
    public void enumDataTypeHelper() {
        SchemaRetrievalOptionsBuilder builder = SchemaRetrievalOptionsBuilder.builder();
        MatcherAssert.assertThat((Object)builder.enumDataTypeHelper.getEnumDataTypeInfo(null, null, null).getType(), (Matcher)CoreMatchers.is((Object)EnumDataTypeInfo.EnumDataTypeTypes.not_enumerated));
        builder.withEnumDataTypeHelper((column, columnDataType, connection) -> new EnumDataTypeInfo(EnumDataTypeInfo.EnumDataTypeTypes.enumerated_column, Collections.emptyList()));
        MatcherAssert.assertThat((Object)builder.enumDataTypeHelper.getEnumDataTypeInfo(null, null, null).getType(), (Matcher)CoreMatchers.is((Object)EnumDataTypeInfo.EnumDataTypeTypes.enumerated_column));
        builder.withEnumDataTypeHelper(null);
        MatcherAssert.assertThat((Object)builder.enumDataTypeHelper.getEnumDataTypeInfo(null, null, null).getType(), (Matcher)CoreMatchers.is((Object)EnumDataTypeInfo.EnumDataTypeTypes.not_enumerated));
    }

    @Test
    public void fromOptions() {
        SchemaRetrievalOptions options = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions();
        SchemaRetrievalOptionsBuilder builder = SchemaRetrievalOptionsBuilder.builder((SchemaRetrievalOptions)options);
        MatcherAssert.assertThat((Object)builder.supportsCatalogs, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.supportsSchemas, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isEmpty());
    }

    @Test
    public void fromOptions_null() {
        SchemaRetrievalOptionsBuilder builder = SchemaRetrievalOptionsBuilder.builder().fromOptions(null);
        MatcherAssert.assertThat((Object)builder.supportsCatalogs, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.supportsSchemas, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isEmpty());
    }

    @Test
    public void identifierQuoteString() {
        SchemaRetrievalOptionsBuilder builder = SchemaRetrievalOptionsBuilder.builder();
        MatcherAssert.assertThat((Object)builder.identifierQuoteString, (Matcher)CoreMatchers.is((Object)""));
        builder.withIdentifierQuoteString("@");
        MatcherAssert.assertThat((Object)builder.identifierQuoteString, (Matcher)CoreMatchers.is((Object)"@"));
        builder.withoutIdentifierQuoteString();
        MatcherAssert.assertThat((Object)builder.identifierQuoteString, (Matcher)CoreMatchers.is((Object)""));
        builder.withIdentifierQuoteString(null);
        MatcherAssert.assertThat((Object)builder.identifierQuoteString, (Matcher)CoreMatchers.is((Object)""));
        builder.withIdentifierQuoteString("\t");
        MatcherAssert.assertThat((Object)builder.identifierQuoteString, (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void informationSchemaViews() {
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withSql(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES, "SELECT * FROM DUAL").toOptions();
        SchemaRetrievalOptionsBuilder builder = SchemaRetrievalOptionsBuilder.builder();
        MatcherAssert.assertThat((Object)builder.getInformationSchemaViews().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        builder.withInformationSchemaViews(informationSchemaViews);
        MatcherAssert.assertThat((Object)builder.getInformationSchemaViews().isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        builder.withInformationSchemaViews(null);
        MatcherAssert.assertThat((Object)builder.getInformationSchemaViews().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void metadataRetrievalStrategy() {
        SchemaRetrievalOptionsBuilder builder = SchemaRetrievalOptionsBuilder.builder();
        MetadataRetrievalStrategy metadataRetrievalStrategy = builder.get(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy);
        MatcherAssert.assertThat((Object)metadataRetrievalStrategy, (Matcher)CoreMatchers.is((Object)MetadataRetrievalStrategy.metadata));
        builder.with(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all);
        metadataRetrievalStrategy = builder.get(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy);
        MatcherAssert.assertThat((Object)metadataRetrievalStrategy, (Matcher)CoreMatchers.is((Object)MetadataRetrievalStrategy.data_dictionary_all));
        MatcherAssert.assertThat((Object)builder.get(null), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        builder.with(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all);
        metadataRetrievalStrategy = builder.get(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy);
        MatcherAssert.assertThat((Object)metadataRetrievalStrategy, (Matcher)CoreMatchers.is((Object)MetadataRetrievalStrategy.data_dictionary_all));
        builder.with(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy, null);
        metadataRetrievalStrategy = builder.get(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy);
        MatcherAssert.assertThat((Object)metadataRetrievalStrategy, (Matcher)CoreMatchers.is((Object)MetadataRetrievalStrategy.metadata));
        builder.with(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all);
        metadataRetrievalStrategy = builder.get(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy);
        MatcherAssert.assertThat((Object)metadataRetrievalStrategy, (Matcher)CoreMatchers.is((Object)MetadataRetrievalStrategy.data_dictionary_all));
        builder.with(null, MetadataRetrievalStrategy.metadata);
        metadataRetrievalStrategy = builder.get(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy);
        MatcherAssert.assertThat((Object)metadataRetrievalStrategy, (Matcher)CoreMatchers.is((Object)MetadataRetrievalStrategy.data_dictionary_all));
        builder.with(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all);
        metadataRetrievalStrategy = builder.get(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy);
        MatcherAssert.assertThat((Object)metadataRetrievalStrategy, (Matcher)CoreMatchers.is((Object)MetadataRetrievalStrategy.data_dictionary_all));
        builder.with(null, null);
        metadataRetrievalStrategy = builder.get(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy);
        MatcherAssert.assertThat((Object)metadataRetrievalStrategy, (Matcher)CoreMatchers.is((Object)MetadataRetrievalStrategy.data_dictionary_all));
    }

    @Test
    public void override_catalog_schema() {
        SchemaRetrievalOptionsBuilder builder = SchemaRetrievalOptionsBuilder.builder();
        MatcherAssert.assertThat((Object)builder.overridesSupportsCatalogs, (Matcher)OptionalMatchers.isEmpty());
        builder.withSupportsCatalogs();
        MatcherAssert.assertThat((Object)builder.overridesSupportsCatalogs, (Matcher)OptionalMatchers.isPresentAndIs((Object)true));
        builder.withoutSupportsCatalogs();
        MatcherAssert.assertThat((Object)builder.overridesSupportsCatalogs, (Matcher)OptionalMatchers.isEmpty());
        builder.withDoesNotSupportCatalogs();
        MatcherAssert.assertThat((Object)builder.overridesSupportsCatalogs, (Matcher)OptionalMatchers.isPresentAndIs((Object)false));
        MatcherAssert.assertThat((Object)builder.overridesSupportsSchemas, (Matcher)OptionalMatchers.isEmpty());
        builder.withSupportsSchemas();
        MatcherAssert.assertThat((Object)builder.overridesSupportsSchemas, (Matcher)OptionalMatchers.isPresentAndIs((Object)true));
        builder.withoutSupportsSchemas();
        MatcherAssert.assertThat((Object)builder.overridesSupportsSchemas, (Matcher)OptionalMatchers.isEmpty());
        builder.withDoesNotSupportSchemas();
        MatcherAssert.assertThat((Object)builder.overridesSupportsSchemas, (Matcher)OptionalMatchers.isPresentAndIs((Object)false));
    }

    @Test
    public void toOptions() {
        SchemaRetrievalOptionsBuilder builder = SchemaRetrievalOptionsBuilder.builder();
        SchemaRetrievalOptions schemaRetrievalOptions = builder.toOptions();
        MatcherAssert.assertThat((Object)schemaRetrievalOptions.toString(), (Matcher)CoreMatchers.containsString((String)("\"@object\": \"" + schemaRetrievalOptions.getClass().getName() + "\"")));
    }

    @Test
    public void typeMap() {
        SchemaRetrievalOptionsBuilder builder = SchemaRetrievalOptionsBuilder.builder();
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)builder.toOptions().getTypeMap(), (Matcher)CoreMatchers.is((Matcher)Matchers.aMapWithSize((int)39)));
        HashMap<String, Class<String>> typeMap = new HashMap<String, Class<String>>();
        typeMap.put(String.class.getSimpleName(), String.class);
        builder.withTypeMap(typeMap);
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isPresent());
        MatcherAssert.assertThat((Object)((TypeMap)builder.overridesTypeMap.get()).size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)builder.toOptions().getTypeMap(), (Matcher)CoreMatchers.is((Matcher)Matchers.aMapWithSize((int)1)));
        MatcherAssert.assertThat((Object)builder.toOptions().getTypeMap(), (Matcher)Matchers.hasKey((Object)"String"));
        builder.withTypeMap(null);
        MatcherAssert.assertThat((Object)builder.overridesTypeMap, (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)builder.toOptions().getTypeMap(), (Matcher)CoreMatchers.is((Matcher)Matchers.aMapWithSize((int)39)));
    }
}

