/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.OrderingComparison;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import schemacrawler.schemacrawler.DatabaseServerType;

public class DatabaseServerTypeTest {
    @Test
    public void badConstructorArguments() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DatabaseServerType(null, "NewDB"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DatabaseServerType(" ", "NewDB"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DatabaseServerType("newdb", null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DatabaseServerType("newdb", ""));
    }

    @Test
    public void compareTo() {
        DatabaseServerType databaseServerType0 = DatabaseServerType.UNKNOWN;
        DatabaseServerType databaseServerType1 = new DatabaseServerType("newdb", "NewDB");
        MatcherAssert.assertThat((Object)databaseServerType0, (Matcher)OrderingComparison.lessThan(null));
        MatcherAssert.assertThat((Object)databaseServerType1, (Matcher)OrderingComparison.lessThan(null));
        MatcherAssert.assertThat((Object)databaseServerType0, (Matcher)OrderingComparison.comparesEqualTo((Comparable)databaseServerType0));
        MatcherAssert.assertThat((Object)databaseServerType1, (Matcher)OrderingComparison.comparesEqualTo((Comparable)databaseServerType1));
        MatcherAssert.assertThat((Object)databaseServerType0, (Matcher)OrderingComparison.lessThan((Comparable)databaseServerType1));
        MatcherAssert.assertThat((Object)databaseServerType1, (Matcher)OrderingComparison.greaterThan((Comparable)databaseServerType0));
    }

    @Test
    public void equals() {
        EqualsVerifier.forClass(DatabaseServerType.class).withIgnoredFields(new String[]{"databaseSystemName"}).verify();
    }

    @Test
    public void properties0() {
        DatabaseServerType databaseServerType = DatabaseServerType.UNKNOWN;
        MatcherAssert.assertThat((Object)databaseServerType.getDatabaseSystemIdentifier(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)databaseServerType.getDatabaseSystemIdentifier(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)databaseServerType.isUnknownDatabaseSystem(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)databaseServerType.hashCode(), (Matcher)CoreMatchers.is((Object)31));
    }

    @Test
    public void properties1() {
        DatabaseServerType databaseServerType = new DatabaseServerType("newdb", "NewDB");
        MatcherAssert.assertThat((Object)databaseServerType.getDatabaseSystemIdentifier(), (Matcher)CoreMatchers.is((Object)"newdb"));
        MatcherAssert.assertThat((Object)databaseServerType.getDatabaseSystemIdentifier(), (Matcher)CoreMatchers.is((Object)"newdb"));
        MatcherAssert.assertThat((Object)databaseServerType.isUnknownDatabaseSystem(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void string() {
        DatabaseServerType databaseServerType0 = DatabaseServerType.UNKNOWN;
        DatabaseServerType databaseServerType1 = new DatabaseServerType("newdb", "NewDB");
        MatcherAssert.assertThat((Object)databaseServerType0.toString(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)databaseServerType1.toString(), (Matcher)CoreMatchers.is((Object)"newdb - NewDB"));
    }
}

