/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.string.FileContents;

public class FileContentsTest {
    @Test
    public void badEncoding() throws IOException {
        String text = "Hello, World!";
        Path tempFilePath = IOUtility.createTempFilePath((String)"test", (String)".dat");
        Files.write(tempFilePath, "Hello, World!".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        FileContents fileContents = new FileContents(tempFilePath, StandardCharsets.UTF_16);
        MatcherAssert.assertThat((Object)fileContents.get(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)"Hello, World!")));
    }

    @Test
    public void happyPath() throws IOException {
        String text = "Hello, World!";
        Path tempFilePath = IOUtility.createTempFilePath((String)"test", (String)".dat");
        Files.write(tempFilePath, "Hello, World!".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        FileContents fileContents = new FileContents(tempFilePath);
        MatcherAssert.assertThat((Object)fileContents.get(), (Matcher)Matchers.is((Object)"Hello, World!"));
    }

    @Test
    public void notReadable() throws IOException {
        FileContents fileContents = new FileContents(Paths.get("fakepath", new String[0]));
        MatcherAssert.assertThat((Object)fileContents.get(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void nullcheck() throws IOException {
        Assertions.assertThrows(NullPointerException.class, () -> new FileContents(null));
        Path tempFilePath = IOUtility.createTempFilePath((String)"test", (String)".dat");
        Assertions.assertThrows(NullPointerException.class, () -> new FileContents(tempFilePath, null));
    }
}

