/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.io.IOException;
import java.sql.Connection;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.context.annotation.Description;
import schemacrawler.crawl.ForeignKeyRetrieverTest;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestContext;
import schemacrawler.test.utility.WithTestDatabase;

@ResolveTestContext
@WithTestDatabase(script="fk_dupe_name.sql")
public class ForeignKeyNamesTest {
    private Catalog catalog;

    @Test
    @Description(value="Verify that foreign key names are scoped within a schema")
    public void fkNames(TestContext testContext) throws IOException {
        ForeignKeyRetrieverTest.verifyRetrieveForeignKeys(this.catalog, testContext.testMethodFullName());
    }

    @BeforeEach
    public void loadCatalog(Connection connection) throws Exception {
        LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.maximum());
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLoadOptions(loadOptionsBuilder.toOptions());
        this.catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
    }
}

