/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import com.github.npathai.hamcrestopt.OptionalMatchers;
import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import schemacrawler.inclusionrule.ExcludeAll;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schemacrawler.GrepOptions;
import schemacrawler.schemacrawler.GrepOptionsBuilder;

public class GrepOptionsBuilderTest {
    @Test
    public void fromOptions() {
        GrepOptionsBuilder builder1 = GrepOptionsBuilder.builder();
        builder1.includeGreppedColumns((InclusionRule)new IncludeAll()).includeGreppedDefinitions((InclusionRule)new IncludeAll()).includeGreppedRoutineParameters((InclusionRule)new IncludeAll()).invertGrepMatch(true);
        GrepOptionsBuilder builder = GrepOptionsBuilder.builder().fromOptions(builder1.toOptions());
        GrepOptions grepOptions = builder.toOptions();
        MatcherAssert.assertThat((Object)grepOptions.getGrepColumnInclusionRule(), (Matcher)OptionalMatchers.isPresent());
        MatcherAssert.assertThat((Object)grepOptions.getGrepDefinitionInclusionRule(), (Matcher)OptionalMatchers.isPresent());
        MatcherAssert.assertThat((Object)grepOptions.getGrepRoutineParameterInclusionRule(), (Matcher)OptionalMatchers.isPresent());
        GrepOptionsBuilder builderNull = GrepOptionsBuilder.builder().fromOptions(null);
        this.checkAllDefaults(builderNull.toOptions());
    }

    @Test
    public void includeGreppedColumns() {
        GrepOptionsBuilder builder = GrepOptionsBuilder.builder();
        this.checkAllDefaults(builder.toOptions());
        builder.includeGreppedColumns((InclusionRule)new ExcludeAll());
        MatcherAssert.assertThat((Object)builder.toOptions().getGrepColumnInclusionRule(), (Matcher)OptionalMatchers.isPresentAndIs((Object)new ExcludeAll()));
        MatcherAssert.assertThat((Object)builder.toOptions().isGrepColumns(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void includeGreppedColumnsPattern() {
        GrepOptionsBuilder builder = GrepOptionsBuilder.builder();
        this.checkAllDefaults(builder.toOptions());
        builder.includeGreppedColumns(Pattern.compile(".*"));
        MatcherAssert.assertThat((Object)builder.toOptions().getGrepColumnInclusionRule(), (Matcher)OptionalMatchers.isPresent());
        builder.includeGreppedColumns((Pattern)null);
        MatcherAssert.assertThat((Object)builder.toOptions().getGrepColumnInclusionRule(), (Matcher)OptionalMatchers.isEmpty());
        this.checkAllDefaults(builder.toOptions());
    }

    @Test
    public void includeGreppedDefinitions() {
        GrepOptionsBuilder builder = GrepOptionsBuilder.builder();
        this.checkAllDefaults(builder.toOptions());
        builder.includeGreppedDefinitions((InclusionRule)new ExcludeAll());
        MatcherAssert.assertThat((Object)builder.toOptions().getGrepDefinitionInclusionRule(), (Matcher)OptionalMatchers.isPresentAndIs((Object)new ExcludeAll()));
        MatcherAssert.assertThat((Object)builder.toOptions().isGrepDefinitions(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void includeGreppedDefinitionsPattern() {
        GrepOptionsBuilder builder = GrepOptionsBuilder.builder();
        this.checkAllDefaults(builder.toOptions());
        builder.includeGreppedDefinitions(Pattern.compile(".*"));
        MatcherAssert.assertThat((Object)builder.toOptions().getGrepDefinitionInclusionRule(), (Matcher)OptionalMatchers.isPresent());
        builder.includeGreppedDefinitions((Pattern)null);
        MatcherAssert.assertThat((Object)builder.toOptions().getGrepDefinitionInclusionRule(), (Matcher)OptionalMatchers.isEmpty());
        this.checkAllDefaults(builder.toOptions());
    }

    @Test
    public void includeGreppedRoutineParameters() {
        GrepOptionsBuilder builder = GrepOptionsBuilder.builder();
        this.checkAllDefaults(builder.toOptions());
        builder.includeGreppedRoutineParameters((InclusionRule)new ExcludeAll());
        MatcherAssert.assertThat((Object)builder.toOptions().getGrepRoutineParameterInclusionRule(), (Matcher)OptionalMatchers.isPresentAndIs((Object)new ExcludeAll()));
        MatcherAssert.assertThat((Object)builder.toOptions().isGrepRoutineParameters(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void includeGreppedRoutineParametersPattern() {
        GrepOptionsBuilder builder = GrepOptionsBuilder.builder();
        this.checkAllDefaults(builder.toOptions());
        builder.includeGreppedRoutineParameters(Pattern.compile(".*"));
        MatcherAssert.assertThat((Object)builder.toOptions().getGrepRoutineParameterInclusionRule(), (Matcher)OptionalMatchers.isPresent());
        builder.includeGreppedRoutineParameters((Pattern)null);
        MatcherAssert.assertThat((Object)builder.toOptions().getGrepRoutineParameterInclusionRule(), (Matcher)OptionalMatchers.isEmpty());
        this.checkAllDefaults(builder.toOptions());
    }

    @Test
    public void isGrepInvertMatch() {
        GrepOptionsBuilder builder = GrepOptionsBuilder.builder();
        this.checkAllDefaults(builder.toOptions());
        builder.invertGrepMatch(true);
        MatcherAssert.assertThat((Object)builder.toOptions().isGrepInvertMatch(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void newOptions() {
        GrepOptions grepOptions = GrepOptionsBuilder.newGrepOptions();
        this.checkAllDefaults(grepOptions);
    }

    private void checkAllDefaults(GrepOptions grepOptionsNew) {
        MatcherAssert.assertThat((Object)grepOptionsNew.getGrepColumnInclusionRule(), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)grepOptionsNew.getGrepDefinitionInclusionRule(), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)grepOptionsNew.getGrepRoutineParameterInclusionRule(), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)grepOptionsNew.isGrepColumns(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)grepOptionsNew.isGrepDefinitions(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)grepOptionsNew.isGrepRoutineParameters(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)grepOptionsNew.isGrepInvertMatch(), (Matcher)CoreMatchers.is((Object)false));
    }
}

